package tech.grasshopper.pdf;

import static org.apache.pdfbox.pdmodel.PDPageContentStream.AppendMode.APPEND;

import java.awt.Color;
import java.io.IOException;
import java.util.Comparator;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.vandeseer.easytable.RepeatedHeaderTableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;

import tech.grasshopper.pdf.tablecell.TableWithinTableCell;

import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell.Paragraph;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell.Paragraph.ParagraphBuilder;

public class SplitTrierTC {

	private Table table;

	private PDDocument document;

	public static void main(String[] args) throws IOException {

		SplitTrierTC st = new SplitTrierTC();
		st.createTable();
	}

	public void createTable() throws IOException {

		document = new PDDocument();
		PDPage my_page = new PDPage(PDRectangle.A4);
		document.addPage(my_page);

		PDPageContentStream content = new PDPageContentStream(document, my_page, APPEND, true);
		content.beginText();
		content.setFont(PDType1Font.TIMES_ROMAN, 15);
		content.newLineAtOffset(50, 500);
		content.showText("This line is added to ensure table is drawn on new page when space not available.");
		content.endText();
		content.close();

		TableBuilder builder = Table.builder().addColumnsOfWidth(50, 400, 50).borderColor(Color.LIGHT_GRAY)
				.borderWidth(1).font(PDType1Font.TIMES_ROMAN).fontSize(13).verticalAlignment(VerticalAlignment.TOP)
				.horizontalAlignment(HorizontalAlignment.LEFT).padding(5)

				.addRow(Row.builder().add(TextCell.builder().text("Repeat Row 1").borderWidth(0).colSpan(3).build())
						.build())
				.addRow(Row.builder().add(TextCell.builder().text("Repeat Row 2").borderWidth(0).colSpan(3).build())
						.build());

		for (int i = 1; i < 4; i++) {
			builder.addRow(Row.builder().add(TextCell.builder().text(String.valueOf(i)).build()).add(TextCell.builder()
					.text("EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX PDFBoX EASYTABLE PDFBoX PDFBoX EASYTABLE PDFBoX ")
					.lineSpacing(1).build()).add(TextCell.builder().text(String.valueOf(i * 10)).build()).build());
		}

		TableBuilder intBuilder = Table.builder().addColumnsOfWidth(175, 175).borderColor(Color.GRAY).borderWidth(1)
				.font(PDType1Font.TIMES_ROMAN).fontSize(10).verticalAlignment(VerticalAlignment.MIDDLE)
				.horizontalAlignment(HorizontalAlignment.CENTER).padding(5)
				.addRow(Row.builder().add(TextCell.builder().text("Cell 000").colSpan(2).build()).build())
				.addRow(Row.builder().add(TextCell.builder().text("Cell 1").build())
						.add(TextCell.builder().text("Cell 2").build()).build())
				.addRow(Row.builder().add(TextCell.builder().text("Cell 3 big big big details details").build())
						.add(TextCell.builder().text("Cell 4 big big big details details").build()).build())
				.addRow(Row.builder().add(TextCell.builder().text("Cell 5").build())
						.add(TextCell.builder().text("Cell 6").build()).build())
				.addRow(Row.builder().add(TextCell.builder().text("Cell 7").build())
						.add(TextCell.builder().text("Cell 8").build()).build());

		builder.addRow(Row.builder().add(TextCell.builder().text("11").build())
				.add(TableWithinTableCell.builder().table(intBuilder.build()).build())
				.add(TextCell.builder().text("33").build()).build());

		table = builder.build();

		RepeatedHeaderTableDrawer.builder().table(table).startX(50f).startY(350f).endY(50F).numberOfRowsToRepeat(2)

				.build().draw(() -> document, () -> new PDPage(PDRectangle.A4), 50f);

		document.save("target/splittcreport.pdf");

		/*
		 * System.out.println("row height" + " -- " + "max cell height" + " -- " +
		 * "next row" + " -- " + "cell count");
		 * 
		 * table.getRows().forEach(r -> System.out.println(r.getHeight() + " -- " +
		 * getHighestCellOf(r) + " -- " + r.getNext() + " -- " + r.getCells().size() ));
		 */
		document.close();
	}

	private Float getHighestCellOf(Row row) {
		return row.getCells().stream().map(AbstractCell::getHeight).max(Comparator.naturalOrder())
				.orElse(row.getHeight());
	}
}
