/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation.cell;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.drawing.DrawingContext;
import org.vandeseer.easytable.drawing.DrawingUtil;
import org.vandeseer.easytable.drawing.PositionedLine;
import org.vandeseer.easytable.drawing.PositionedStyledText;
import org.vandeseer.easytable.drawing.cell.TextCellDrawer;
import org.vandeseer.easytable.settings.BorderStyle;
import org.vandeseer.easytable.settings.BorderStyleInterface;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.cell.AbstractTextCell;
import org.vandeseer.easytable.util.PdfUtil;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.cell.TextLinkCell;

public class TextLinkCellDrawer<T extends TextLinkCell>
extends TextCellDrawer<TextLinkCell> {
    private Annotation annotation;
    private boolean showLine;

    public TextLinkCellDrawer(T cell, Annotation annotation, boolean showLine) {
        this.cell = cell;
        this.annotation = annotation;
        this.showLine = showLine;
    }

    public void drawContent(DrawingContext drawingContext) {
        float startX = drawingContext.getStartingPoint().x;
        PDFont currentFont = ((AbstractTextCell)this.cell).getFont();
        int currentFontSize = ((AbstractTextCell)this.cell).getFontSize();
        Color currentTextColor = ((AbstractTextCell)this.cell).getTextColor();
        float yOffset = drawingContext.getStartingPoint().y + this.getAdaptionForVerticalAlignment();
        float xOffset = startX + ((AbstractTextCell)this.cell).getPaddingLeft();
        List lines = this.calculateAndGetLines(currentFont, currentFontSize, ((AbstractTextCell)this.cell).getMaxWidth());
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            yOffset -= this.calculateYOffset(currentFont, currentFontSize, i);
            float textWidth = PdfUtil.getStringWidth((String)line, (PDFont)currentFont, (int)currentFontSize);
            if (((AbstractTextCell)this.cell).isHorizontallyAligned(HorizontalAlignment.RIGHT)) {
                xOffset = startX + (((AbstractTextCell)this.cell).getWidth() - (textWidth + ((AbstractTextCell)this.cell).getPaddingRight()));
            } else if (((AbstractTextCell)this.cell).isHorizontallyAligned(HorizontalAlignment.CENTER)) {
                xOffset = startX + (((AbstractTextCell)this.cell).getWidth() - textWidth) / 2.0f;
            } else if (((AbstractTextCell)this.cell).isHorizontallyAligned(HorizontalAlignment.JUSTIFY) && i != lines.size() - 1) {
                drawingContext.getContentStream().setCharacterSpacing(this.calculateCharSpacingFor(line));
            }
            this.drawText(drawingContext, PositionedStyledText.builder().x(xOffset).y(yOffset).text(line).font(currentFont).fontSize(currentFontSize).color(currentTextColor).build());
            if (!this.showLine) continue;
            float lineOffset = (float)currentFontSize * currentFont.getFontDescriptor().getAscent() / 3000.0f;
            this.drawLine(drawingContext, PositionedLine.builder().startX(xOffset).endX(xOffset + textWidth).width(0.01f + (float)currentFontSize * 0.05f).startY(yOffset - lineOffset).endY(yOffset - lineOffset).color(Color.BLACK).resetColor(currentTextColor).borderStyle((BorderStyleInterface)BorderStyle.SOLID).build());
        }
        this.updateAnnotation(drawingContext);
    }

    protected float calculateYOffset(PDFont currentFont, int currentFontSize, int lineIndex) {
        return PdfUtil.getFontHeight((PDFont)currentFont, (int)currentFontSize) + (lineIndex > 0 ? PdfUtil.getFontHeight((PDFont)currentFont, (int)currentFontSize) * ((AbstractTextCell)this.cell).getLineSpacing() : 0.0f);
    }

    protected void drawLine(DrawingContext drawingContext, PositionedLine positionedLine) throws IOException {
        DrawingUtil.drawLine((PDPageContentStream)drawingContext.getContentStream(), (PositionedLine)positionedLine);
    }

    private void updateAnnotation(DrawingContext drawingContext) {
        this.annotation.setXBottom(drawingContext.getStartingPoint().x);
        this.annotation.setYBottom(drawingContext.getStartingPoint().y);
        this.annotation.setWidth(((AbstractTextCell)this.cell).getWidth());
        this.annotation.setHeight(((AbstractTextCell)this.cell).getRow().getHeight());
        this.annotation.setPage(drawingContext.getPage());
    }

    public TextLinkCellDrawer() {
    }
}

