/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.filter;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.internal.NameAndValue;
import io.restassured.internal.support.Prettifier;
import io.restassured.response.Response;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import tech.grasshopper.attachment.ExtentHttpRequestAttachment;
import tech.grasshopper.renderer.JsonAttachmentRenderer;

public class ExtentRestAssuredFilter
implements OrderedFilter {
    private String requestAttachmentName = "Request";
    private String responseAttachmentName = "Response";

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext filterContext) {
        Prettifier prettifier = new Prettifier();
        ExtentHttpRequestAttachment.ExtentHttpRequestAttachmentBuilder extentRequestAttachmentBuilder = ExtentHttpRequestAttachment.builder();
        extentRequestAttachmentBuilder.url(requestSpec.getURI()).name(this.requestAttachmentName).method(requestSpec.getMethod()).headers(ExtentRestAssuredFilter.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getHeaders())).cookies(ExtentRestAssuredFilter.toMapConverter((Iterable<? extends NameAndValue>)requestSpec.getCookies())).requestParameters(requestSpec.getRequestParams()).queryParameters(requestSpec.getQueryParams()).formParameters(requestSpec.getFormParams()).pathParameters(requestSpec.getNamedPathParams()).multiParts(requestSpec.getMultiPartParams());
        if (Objects.nonNull(requestSpec.getBody())) {
            extentRequestAttachmentBuilder.body(prettifier.getPrettifiedBodyIfPossible(requestSpec));
        }
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)extentRequestAttachmentBuilder.build(), (AttachmentRenderer)new JsonAttachmentRenderer());
        Response response = filterContext.next(requestSpec, responseSpec);
        HttpResponseAttachment responseAttachment = HttpResponseAttachment.Builder.create((String)this.responseAttachmentName).setResponseCode(response.getStatusCode()).setHeaders(ExtentRestAssuredFilter.toMapConverter((Iterable<? extends NameAndValue>)response.getHeaders())).setCookies(response.getCookies()).setBody(prettifier.getPrettifiedBodyIfPossible((ResponseOptions)response, response.getBody())).build();
        new DefaultAttachmentProcessor().addAttachment((AttachmentData)responseAttachment, (AttachmentRenderer)new JsonAttachmentRenderer());
        return response;
    }

    private static Map<String, String> toMapConverter(Iterable<? extends NameAndValue> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach(h -> result.put(h.getName(), h.getValue()));
        return result;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

