/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.extent.processor.DataTableProcessor;
import tech.grasshopper.pdf.extent.processor.DocStringProcessor;
import tech.grasshopper.pdf.extent.processor.LogMessageProcessor;
import tech.grasshopper.pdf.extent.processor.MediaProcessor;
import tech.grasshopper.pdf.extent.processor.StackTraceProcessor;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Row;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.util.DateUtil;

public class ExtentPDFReportDataGenerator {
    private String mediaFolder;

    public ExtentPDFReportDataGenerator(String mediaFolder) {
        this.mediaFolder = mediaFolder;
    }

    public ReportData generateReportData(Report report) {
        List extentTests = report.getTestList();
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Test featureTest : extentTests) {
            ArrayList featureTags = new ArrayList();
            featureTest.getCategorySet().stream().forEach(c -> {
                boolean bl = featureTags.add(c.getName());
            });
            ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
            Feature feature = ((Feature.FeatureBuilder)((Feature.FeatureBuilder)Feature.builder().name(featureTest.getName()).status(this.convertStatus(featureTest.getStatus())).tags(featureTags).scenarios(scenarios).startTime(DateUtil.convertToLocalDateTimeFromDate((Date)featureTest.getStartTime()))).endTime(DateUtil.convertToLocalDateTimeFromDate((Date)featureTest.getEndTime()))).build();
            features.add(feature);
            for (Test scenarioTest : featureTest.getChildren()) {
                if (scenarioTest.getBddType() == ScenarioOutline.class) {
                    for (Test soScenarioTest : scenarioTest.getChildren()) {
                        this.createScenarioHookSteps(soScenarioTest, scenarios);
                    }
                    continue;
                }
                this.createScenarioHookSteps(scenarioTest, scenarios);
            }
        }
        return ReportData.builder().features(features).build();
    }

    private void createScenarioHookSteps(Test scenarioTest, List<Scenario> scenarios) {
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<Hook> beforeHook = new ArrayList<Hook>();
        ArrayList<Hook> afterHook = new ArrayList<Hook>();
        ArrayList scenarioTags = new ArrayList();
        scenarioTest.getCategorySet().stream().forEach(c -> {
            boolean bl = scenarioTags.add(c.getName());
        });
        Scenario scenario = ((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)Scenario.builder().name(scenarioTest.getName()).status(this.convertStatus(scenarioTest.getStatus())).tags(scenarioTags).steps(steps).before(beforeHook).after(afterHook).startTime(DateUtil.convertToLocalDateTimeFromDate((Date)scenarioTest.getStartTime()))).endTime(DateUtil.convertToLocalDateTimeFromDate((Date)scenarioTest.getEndTime()))).build();
        scenarios.add(scenario);
        Step step = null;
        LoopObject loopObject = LoopObject.INITIAL;
        for (Test stepTest : scenarioTest.getChildren()) {
            if (stepTest.getBddType() == Asterisk.class) {
                Hook.HookType type = Hook.HookType.valueOf((String)stepTest.getDescription().toUpperCase());
                switch (type) {
                    case BEFORE: {
                        this.addHookData(beforeHook, stepTest);
                        break;
                    }
                    case AFTER: {
                        this.addHookData(afterHook, stepTest);
                        break;
                    }
                    case BEFORE_STEP: {
                        if (loopObject == LoopObject.INITIAL || loopObject == LoopObject.STEP || loopObject == LoopObject.AFTER_STEP) {
                            step = Step.builder().build();
                        }
                        step.addBeforeStepHook(this.createHook(stepTest));
                        loopObject = LoopObject.BEFORE_STEP;
                        break;
                    }
                    case AFTER_STEP: {
                        step.addAfterStepHook(this.createHook(stepTest));
                        loopObject = LoopObject.AFTER_STEP;
                    }
                }
                continue;
            }
            if (loopObject == LoopObject.INITIAL || loopObject == LoopObject.STEP || loopObject == LoopObject.AFTER_STEP) {
                step = Step.builder().build();
            }
            this.addStepData(step, stepTest);
            steps.add(step);
            loopObject = LoopObject.STEP;
        }
    }

    private void addStepData(Step step, Test stepTest) {
        step.setName(stepTest.getName());
        step.setStatus(this.convertStatus(stepTest.getStatus()));
        step.setKeyword(stepTest.getBddType().getSimpleName());
        step.setErrorMessage(this.getStackTrace(stepTest));
        step.setOutput(this.getLogMessages(stepTest));
        step.setMedia(this.getMediaData(stepTest));
        step.setStartTime(DateUtil.convertToLocalDateTimeFromDate((Date)stepTest.getStartTime()));
        step.setEndTime(DateUtil.convertToLocalDateTimeFromDate((Date)stepTest.getEndTime()));
        step.setDocString(this.getDocString(stepTest));
        step.setRows(this.getDataTable(stepTest));
    }

    private void addHookData(List<Hook> hooks, Test hookTest) {
        hooks.add(this.createHook(hookTest));
    }

    private Hook createHook(Test hookTest) {
        return ((Hook.HookBuilder)((Hook.HookBuilder)Hook.builder().location(hookTest.getName()).hookType(Hook.HookType.valueOf((String)hookTest.getDescription())).status(this.convertStatus(hookTest.getStatus())).errorMessage(this.getStackTrace(hookTest)).output(this.getLogMessages(hookTest)).media(this.getMediaData(hookTest)).startTime(DateUtil.convertToLocalDateTimeFromDate((Date)hookTest.getStartTime()))).endTime(DateUtil.convertToLocalDateTimeFromDate((Date)hookTest.getEndTime()))).build();
    }

    private tech.grasshopper.pdf.pojo.cucumber.Status convertStatus(Status extentStatus) {
        tech.grasshopper.pdf.pojo.cucumber.Status status = tech.grasshopper.pdf.pojo.cucumber.Status.SKIPPED;
        if (extentStatus == Status.PASS) {
            status = tech.grasshopper.pdf.pojo.cucumber.Status.PASSED;
        } else if (extentStatus == Status.FAIL) {
            status = tech.grasshopper.pdf.pojo.cucumber.Status.FAILED;
        }
        return status;
    }

    private List<Row> getDataTable(Test test) {
        return DataTableProcessor.builder().logs(test.getLogs()).build().process();
    }

    private String getDocString(Test test) {
        return DocStringProcessor.builder().logs(test.getLogs()).build().process();
    }

    private String getStackTrace(Test test) {
        return StackTraceProcessor.builder().logs(test.getLogs()).build().process();
    }

    private List<String> getLogMessages(Test test) {
        return LogMessageProcessor.builder().logs(test.getLogs()).build().process();
    }

    private List<String> getMediaData(Test test) {
        return MediaProcessor.builder().logs(test.getLogs()).mediaFolder(this.mediaFolder).build().process();
    }

    private static enum LoopObject {
        INITIAL,
        BEFORE_STEP,
        STEP,
        AFTER_STEP;

    }
}

