/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class DocStringProcessor {
    private List<Log> logs;

    public String process() {
        for (Log log : this.logs) {
            String html;
            Document doc;
            Element element;
            if (log.getStatus() != Status.PASS || (element = (doc = Jsoup.parseBodyFragment((String)(html = log.getDetails()))).selectFirst("body textarea[class*=\"code-block\"]")) == null) continue;
            return element.text();
        }
        return "";
    }

    private static List<Log> $default$logs() {
        return new ArrayList<Log>();
    }

    DocStringProcessor(List<Log> logs) {
        this.logs = logs;
    }

    public static DocStringProcessorBuilder builder() {
        return new DocStringProcessorBuilder();
    }

    public static class DocStringProcessorBuilder {
        private List<Log> logs;
        private boolean logs$set;

        DocStringProcessorBuilder() {
        }

        public DocStringProcessorBuilder logs(List<Log> logs) {
            this.logs = logs;
            this.logs$set = true;
            return this;
        }

        public DocStringProcessor build() {
            return new DocStringProcessor(this.logs$set ? this.logs : DocStringProcessor.$default$logs());
        }

        public String toString() {
            return "DocStringProcessor.DocStringProcessorBuilder(logs=" + this.logs + ")";
        }
    }
}

