/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;

public class StackTraceProcessor {
    private List<Log> logs;

    public String process() {
        String stack = "";
        for (Log log : this.logs) {
            if (log.getStatus() != Status.FAIL) continue;
            stack = log.getException() != null ? log.getException().getStackTrace() : this.stripMarkup(log.getDetails());
        }
        return stack;
    }

    private String stripMarkup(String markup) {
        int start = markup.indexOf(">", markup.indexOf("<textarea"));
        int end = markup.indexOf("</textarea");
        if (start == -1 || end == -1) {
            return markup;
        }
        return markup.substring(start + 1, end);
    }

    private static List<Log> $default$logs() {
        return new ArrayList<Log>();
    }

    StackTraceProcessor(List<Log> logs) {
        this.logs = logs;
    }

    public static StackTraceProcessorBuilder builder() {
        return new StackTraceProcessorBuilder();
    }

    public static class StackTraceProcessorBuilder {
        private List<Log> logs;
        private boolean logs$set;

        StackTraceProcessorBuilder() {
        }

        public StackTraceProcessorBuilder logs(List<Log> logs) {
            this.logs = logs;
            this.logs$set = true;
            return this;
        }

        public StackTraceProcessor build() {
            return new StackTraceProcessor(this.logs$set ? this.logs : StackTraceProcessor.$default$logs());
        }

        public String toString() {
            return "StackTraceProcessor.StackTraceProcessorBuilder(logs=" + this.logs + ")";
        }
    }
}

