/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent;

import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.reporter.AbstractFileReporter;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.pdf.PDFCucumberReport;
import tech.grasshopper.pdf.data.ReportData;
import tech.grasshopper.pdf.extent.ExtentPDFReportDataGenerator;
import tech.grasshopper.pdf.section.details.executable.MediaCleanup;

public class ExtentPDFCucumberReporter
extends AbstractFileReporter
implements ReportObserver<ReportEntity> {
    private static final Logger logger = Logger.getLogger(ExtentPDFCucumberReporter.class.getName());
    private static final String REPORTER_NAME = "pdf";
    private static final String FILE_NAME = "Index.pdf";
    private Disposable disposable;
    private Report report;
    private String mediaFolder;
    private MediaCleanup.MediaCleanupOption mediaCleanupOption;

    public ExtentPDFCucumberReporter(String path, String mediaFolder) {
        this(new File(path), mediaFolder, MediaCleanup.MediaCleanupOption.builder().cleanUpType(MediaCleanup.CleanupType.NONE).build());
    }

    public ExtentPDFCucumberReporter(File f, String mediaFolder) {
        this(f, mediaFolder, MediaCleanup.MediaCleanupOption.builder().cleanUpType(MediaCleanup.CleanupType.NONE).build());
    }

    public ExtentPDFCucumberReporter(String path, String mediaFolder, MediaCleanup.MediaCleanupOption mediaCleanupOption) {
        this(new File(path), mediaFolder, mediaCleanupOption);
    }

    public ExtentPDFCucumberReporter(File f, String mediaFolder, MediaCleanup.MediaCleanupOption mediaCleanupOption) {
        super(f);
        this.mediaFolder = mediaFolder;
        this.mediaCleanupOption = mediaCleanupOption;
    }

    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
                ExtentPDFCucumberReporter.this.start(d);
            }

            public void onNext(ReportEntity value) {
                ExtentPDFCucumberReporter.this.flush(value);
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private void start(Disposable d) {
        this.disposable = d;
    }

    private void flush(ReportEntity value) {
        try {
            this.report = value.getReport();
            String filePath = this.getFileNameAsExt(FILE_NAME, new String[]{".pdf"});
            ExtentPDFReportDataGenerator generator = ExtentPDFReportDataGenerator.builder().mediaFolder(this.mediaFolder).build();
            ReportData reportData = generator.generateReportData(this.report);
            PDFCucumberReport pdfCucumberReport = new PDFCucumberReport(reportData, new File(filePath), this.mediaCleanupOption);
            pdfCucumberReport.createReport();
        }
        catch (Exception e) {
            this.disposable.dispose();
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }
}

