/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.extent.processor.Processor;

public class LogMessageProcessor
extends Processor {
    @Override
    public List<String> process() {
        ArrayList<String> output = new ArrayList<String>();
        for (Log log : this.logs) {
            if (log.getStatus() != Status.INFO || log.getDetails().isEmpty()) continue;
            output.add(log.getDetails());
        }
        return output;
    }

    protected LogMessageProcessor(LogMessageProcessorBuilder<?, ?> b) {
        super(b);
    }

    public static LogMessageProcessorBuilder<?, ?> builder() {
        return new LogMessageProcessorBuilderImpl();
    }

    private static final class LogMessageProcessorBuilderImpl
    extends LogMessageProcessorBuilder<LogMessageProcessor, LogMessageProcessorBuilderImpl> {
        private LogMessageProcessorBuilderImpl() {
        }

        @Override
        protected LogMessageProcessorBuilderImpl self() {
            return this;
        }

        @Override
        public LogMessageProcessor build() {
            return new LogMessageProcessor(this);
        }
    }

    public static abstract class LogMessageProcessorBuilder<C extends LogMessageProcessor, B extends LogMessageProcessorBuilder<C, B>>
    extends Processor.ProcessorBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "LogMessageProcessor.LogMessageProcessorBuilder(super=" + super.toString() + ")";
        }
    }
}

