/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.cucumber.adapter;

import io.cucumber.gherkin.Gherkin;
import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.protobuf.GeneratedMessageV3;
import io.cucumber.messages.internal.com.google.protobuf.Message;
import io.cucumber.plugin.event.TestSourceRead;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

final class TestSourcesModel {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final Map<URI, Messages.GherkinDocument> pathToAstMap = new HashMap<URI, Messages.GherkinDocument>();
    private final Map<URI, Map<Integer, AstNode>> pathToNodeMap = new HashMap<URI, Map<Integer, AstNode>>();

    TestSourcesModel() {
    }

    static Messages.GherkinDocument.Feature.Scenario getScenarioDefinition(AstNode astNode) {
        AstNode candidate = astNode;
        while (candidate != null && !(candidate.node instanceof Messages.GherkinDocument.Feature.Scenario)) {
            candidate = candidate.parent;
        }
        return candidate == null ? null : (Messages.GherkinDocument.Feature.Scenario)candidate.node;
    }

    static boolean isBackgroundStep(AstNode astNode) {
        return astNode.parent.node instanceof Messages.GherkinDocument.Feature.Background;
    }

    static String calculateId(AstNode astNode) {
        GeneratedMessageV3 node = astNode.node;
        if (node instanceof Messages.GherkinDocument.Feature.Scenario) {
            return String.valueOf(TestSourcesModel.calculateId(astNode.parent)) + ";" + TestSourcesModel.convertToId(((Messages.GherkinDocument.Feature.Scenario)node).getName());
        }
        if (node instanceof ExamplesRowWrapperNode) {
            return String.valueOf(TestSourcesModel.calculateId(astNode.parent)) + ";" + (((ExamplesRowWrapperNode)node).bodyRowIndex + 2);
        }
        if (node instanceof Messages.GherkinDocument.Feature.TableRow) {
            return String.valueOf(TestSourcesModel.calculateId(astNode.parent)) + ";" + 1;
        }
        if (node instanceof Messages.GherkinDocument.Feature.Scenario.Examples) {
            return String.valueOf(TestSourcesModel.calculateId(astNode.parent)) + ";" + TestSourcesModel.convertToId(((Messages.GherkinDocument.Feature.Scenario.Examples)node).getName());
        }
        if (node instanceof Messages.GherkinDocument.Feature) {
            return TestSourcesModel.convertToId(((Messages.GherkinDocument.Feature)node).getName());
        }
        return "";
    }

    static String convertToId(String name) {
        return name.replaceAll("[\\s'_,!]", "-").toLowerCase();
    }

    static URI relativize(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return uri;
        }
        try {
            URI root = new File("").toURI();
            URI relative = root.relativize(uri);
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    Messages.GherkinDocument.Feature getFeature(URI path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToAstMap.containsKey(path)) {
            return this.pathToAstMap.get(path).getFeature();
        }
        return null;
    }

    private void parseGherkinSource(URI path) {
        if (!this.pathToReadEventMap.containsKey(path)) {
            return;
        }
        String source = this.pathToReadEventMap.get(path).getSource();
        List<Messages.Envelope> sources = Collections.singletonList(Gherkin.makeSourceEnvelope((String)source, (String)path.toString()));
        List envelopes = Gherkin.fromSources(sources, (boolean)true, (boolean)true, (boolean)true, () -> String.valueOf(UUID.randomUUID())).collect(Collectors.toList());
        Messages.GherkinDocument gherkinDocument = envelopes.stream().filter(Messages.Envelope::hasGherkinDocument).map(Messages.Envelope::getGherkinDocument).findFirst().orElse(null);
        this.pathToAstMap.put(path, gherkinDocument);
        HashMap<Integer, AstNode> nodeMap = new HashMap<Integer, AstNode>();
        AstNode currentParent = new AstNode((GeneratedMessageV3)gherkinDocument.getFeature(), null);
        for (Messages.GherkinDocument.Feature.FeatureChild child : gherkinDocument.getFeature().getChildrenList()) {
            this.processFeatureDefinition(nodeMap, child, currentParent);
        }
        this.pathToNodeMap.put(path, nodeMap);
    }

    private void processFeatureDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.FeatureChild child, AstNode currentParent) {
        if (child.hasBackground()) {
            this.processBackgroundDefinition(nodeMap, child.getBackground(), currentParent);
        } else if (child.hasScenario()) {
            this.processScenarioDefinition(nodeMap, child.getScenario(), currentParent);
        } else if (child.hasRule()) {
            AstNode childNode = new AstNode((GeneratedMessageV3)child.getRule(), currentParent);
            nodeMap.put(child.getRule().getLocation().getLine(), childNode);
            for (Messages.GherkinDocument.Feature.FeatureChild.RuleChild ruleChild : child.getRule().getChildrenList()) {
                this.processRuleDefinition(nodeMap, ruleChild, childNode);
            }
        }
    }

    private void processBackgroundDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.Background background, AstNode currentParent) {
        AstNode childNode = new AstNode((GeneratedMessageV3)background, currentParent);
        nodeMap.put(background.getLocation().getLine(), childNode);
        for (Messages.GherkinDocument.Feature.Step step : background.getStepsList()) {
            nodeMap.put(step.getLocation().getLine(), new AstNode((GeneratedMessageV3)step, childNode));
        }
    }

    private void processScenarioDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.Scenario child, AstNode currentParent) {
        AstNode childNode = new AstNode((GeneratedMessageV3)child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Messages.GherkinDocument.Feature.Step step : child.getStepsList()) {
            nodeMap.put(step.getLocation().getLine(), new AstNode((GeneratedMessageV3)step, childNode));
        }
        if (child.getExamplesCount() > 0) {
            this.processScenarioOutlineExamples(nodeMap, child, childNode);
        }
    }

    private void processRuleDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.FeatureChild.RuleChild child, AstNode currentParent) {
        if (child.hasBackground()) {
            this.processBackgroundDefinition(nodeMap, child.getBackground(), currentParent);
        } else if (child.hasScenario()) {
            this.processScenarioDefinition(nodeMap, child.getScenario(), currentParent);
        }
    }

    private void processScenarioOutlineExamples(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.Scenario scenarioOutline, AstNode parent) {
        for (Messages.GherkinDocument.Feature.Scenario.Examples examples : scenarioOutline.getExamplesList()) {
            AstNode examplesNode = new AstNode((GeneratedMessageV3)examples, parent);
            Messages.GherkinDocument.Feature.TableRow headerRow = examples.getTableHeader();
            AstNode headerNode = new AstNode((GeneratedMessageV3)headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            int i = 0;
            while (i < examples.getTableBodyCount()) {
                Messages.GherkinDocument.Feature.TableRow examplesRow = examples.getTableBody(i);
                ExamplesRowWrapperNode rowNode = new ExamplesRowWrapperNode((GeneratedMessageV3)examplesRow, i);
                AstNode expandedScenarioNode = new AstNode(rowNode, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
                ++i;
            }
        }
    }

    AstNode getAstNode(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    boolean hasBackground(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            AstNode astNode = this.pathToNodeMap.get(path).get(line);
            return TestSourcesModel.getBackgroundForTestCase(astNode) != null;
        }
        return false;
    }

    static Messages.GherkinDocument.Feature.Background getBackgroundForTestCase(AstNode astNode) {
        Messages.GherkinDocument.Feature feature = TestSourcesModel.getFeatureForTestCase(astNode);
        return feature.getChildrenList().stream().filter(Messages.GherkinDocument.Feature.FeatureChild::hasBackground).map(Messages.GherkinDocument.Feature.FeatureChild::getBackground).findFirst().orElse(null);
    }

    private static Messages.GherkinDocument.Feature getFeatureForTestCase(AstNode astNode) {
        while (astNode.parent != null) {
            astNode = astNode.parent;
        }
        return (Messages.GherkinDocument.Feature)astNode.node;
    }

    static class AstNode {
        final GeneratedMessageV3 node;
        final AstNode parent;

        AstNode(GeneratedMessageV3 node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }

    static class ExamplesRowWrapperNode
    extends GeneratedMessageV3 {
        final int bodyRowIndex;

        ExamplesRowWrapperNode(GeneratedMessageV3 examplesRow, int bodyRowIndex) {
            this.bodyRowIndex = bodyRowIndex;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            throw new UnsupportedOperationException("not implemented");
        }

        protected Message.Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Message.Builder newBuilderForType() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Message.Builder toBuilder() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Message getDefaultInstanceForType() {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

