/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.messages.types;

import java.util.HashMap;
import java.util.Map;

public class Source {
    private String uri;
    private String data;
    private MediaType mediaType;

    public Source() {
    }

    public Source(String uri, String data, MediaType mediaType) {
        this.uri = uri;
        this.data = data;
        this.mediaType = mediaType;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Source.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uri");
        sb.append('=');
        sb.append(this.uri == null ? "<null>" : this.uri);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(this.mediaType == null ? "<null>" : this.mediaType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Source)) {
            return false;
        }
        Source rhs = (Source)other;
        return (this.mediaType == rhs.mediaType || this.mediaType != null && this.mediaType.equals((Object)rhs.mediaType)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.uri == rhs.uri || this.uri != null && this.uri.equals(rhs.uri));
    }

    public static enum MediaType {
        TEXT_X_CUCUMBER_GHERKIN_PLAIN("text/x.cucumber.gherkin+plain"),
        TEXT_X_CUCUMBER_GHERKIN_MARKDOWN("text/x.cucumber.gherkin+markdown");

        private final String value;
        private static final Map<String, MediaType> CONSTANTS;

        private MediaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static MediaType fromValue(String value) {
            MediaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MediaType>();
            for (MediaType c : MediaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

