/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter;

import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.reporter.ExtentPDFReporter;
import tech.grasshopper.reporter.RestAssuredReportGenerator;

public class RestAssuredPDFReporter
extends ExtentPDFReporter
implements ReportObserver<ReportEntity>,
ReporterConfigurable {
    private static final Logger logger = Logger.getLogger(RestAssuredPDFReporter.class.getName());
    private static final String REPORTER_NAME = "rapdf";
    private static final String FILE_NAME = "ra-report.pdf";
    private Disposable disposable;
    private Report report;

    public RestAssuredPDFReporter(String path) {
        super(new File(path));
    }

    public RestAssuredPDFReporter(File f) {
        super(f);
    }

    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
                RestAssuredPDFReporter.this.start(d);
            }

            public void onNext(ReportEntity value) {
                RestAssuredPDFReporter.this.flush(value);
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private void start(Disposable d) {
        this.disposable = d;
    }

    private void flush(ReportEntity value) {
        try {
            this.report = value.getReport();
            String filePath = this.getFileNameAsExt(FILE_NAME, new String[]{".pdf"});
            RestAssuredReportGenerator reportGenerator = new RestAssuredReportGenerator(this.report, this.config, new File(filePath));
            reportGenerator.generate();
        }
        catch (Exception e) {
            this.disposable.dispose();
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }
}

