/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import tech.grasshopper.reporter.dashboard.legend.DashboardChartLegend;
import tech.grasshopper.reporter.structure.Display;

public class RestAssuredDashboardChartLegendDisplay
extends Display {
    private static final int TOP_LEGEND_Y_LOCATION = 130;
    private static final int CHART_LEGEND_X_PADDING = 25;
    private static final int CHART_FIRST_X_LOCATION = 130;
    private static final int CHART_SECOND_X_LOCATION = 490;
    private static final Map<Status, Color> statusColor = new LinkedHashMap<Status, Color>();

    public void display() {
        statusColor.put(Status.PASS, this.config.getPassColor());
        statusColor.put(Status.FAIL, this.config.getFailColor());
        statusColor.put(Status.SKIP, this.config.getSkipColor());
        statusColor.put(Status.WARNING, this.config.getWarnColor());
        statusColor.put(Status.INFO, this.config.getInfoColor());
        this.createFirstChartLegend();
        this.createSecondChartLegend();
    }

    private void createChartLegend(float xLocation, Map<Status, Long> data) {
        DashboardChartLegend.builder().content(this.content).xlocation(xLocation).ylocation(130.0f).statusColor(statusColor).statusData(data).keyFont(this.reportFont.getItalicFont()).valueFont(this.reportFont.getBoldFont()).build().display();
    }

    private void createFirstChartLegend() {
        this.createChartLegend(155.0f, this.report.getStats().getParent());
    }

    private void createSecondChartLegend() {
        this.createChartLegend(515.0f, this.report.getStats().getChild());
    }

    protected RestAssuredDashboardChartLegendDisplay(RestAssuredDashboardChartLegendDisplayBuilder<?, ?> b) {
        super(b);
    }

    public static RestAssuredDashboardChartLegendDisplayBuilder<?, ?> builder() {
        return new RestAssuredDashboardChartLegendDisplayBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAssuredDashboardChartLegendDisplay)) {
            return false;
        }
        RestAssuredDashboardChartLegendDisplay other = (RestAssuredDashboardChartLegendDisplay)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestAssuredDashboardChartLegendDisplay;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class RestAssuredDashboardChartLegendDisplayBuilderImpl
    extends RestAssuredDashboardChartLegendDisplayBuilder<RestAssuredDashboardChartLegendDisplay, RestAssuredDashboardChartLegendDisplayBuilderImpl> {
        private RestAssuredDashboardChartLegendDisplayBuilderImpl() {
        }

        @Override
        protected RestAssuredDashboardChartLegendDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public RestAssuredDashboardChartLegendDisplay build() {
            return new RestAssuredDashboardChartLegendDisplay(this);
        }
    }

    public static abstract class RestAssuredDashboardChartLegendDisplayBuilder<C extends RestAssuredDashboardChartLegendDisplay, B extends RestAssuredDashboardChartLegendDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "RestAssuredDashboardChartLegendDisplay.RestAssuredDashboardChartLegendDisplayBuilder(super=" + super.toString() + ")";
        }
    }
}

