/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Report;
import java.util.Map;
import tech.grasshopper.reporter.dashboard.AnalysisStrategyDisplay;
import tech.grasshopper.reporter.dashboard.chart.DashboardChartDonut;
import tech.grasshopper.reporter.dashboard.chart.DashboardChartTitle;
import tech.grasshopper.reporter.structure.Display;

public class RestAssuredDashboardDonutChartDisplay
extends Display {
    private static final int CHART_TITLE_X_PADDING = 10;
    private static final int CHART_TITLE_Y_LOCATION = 390;
    private static final float CHART_TITLE_FONT_SIZE = 16.0f;
    private static final int CHART_FIRST_X_LOCATION = 130;
    private static final int CHART_SECOND_X_LOCATION = 490;
    private static final int CHART_DIMENSION = 230;
    private static final int CHART_Y_LOCATION = 150;
    private AnalysisStrategyDisplay strategyDisplay;

    public void display() {
        this.strategyDisplay = AnalysisStrategyDisplay.displaySettings((Report)this.report);
        this.createFirstChartTitle();
        this.createSecondChartTitle();
        this.createFirstDonutChart();
        this.createSecondDonutChart();
    }

    private void createTitle(String title, float xLocation) {
        DashboardChartTitle.builder().content(this.content).font(this.reportFont.getItalicFont()).fontSize(16.0f).xlocation(xLocation).ylocation(390.0f).title(title).build().display();
    }

    private void createFirstChartTitle() {
        this.createTitle(this.strategyDisplay.firstLevelText(), 140.0f);
    }

    private void createSecondChartTitle() {
        this.createTitle(this.strategyDisplay.secondLevelText(), 500.0f);
    }

    private void createDonutChart(float xLocation, Map<Status, Long> data) {
        DashboardChartDonut.builder().content(this.content).document(this.document).config(this.config).width(230).height(230).xlocation(xLocation).ylocation(150.0f).data(data).build().display();
    }

    private void createFirstDonutChart() {
        this.createDonutChart(130.0f, this.report.getStats().getParent());
    }

    private void createSecondDonutChart() {
        this.createDonutChart(490.0f, this.report.getStats().getChild());
    }

    protected RestAssuredDashboardDonutChartDisplay(RestAssuredDashboardDonutChartDisplayBuilder<?, ?> b) {
        super(b);
        this.strategyDisplay = ((RestAssuredDashboardDonutChartDisplayBuilder)b).strategyDisplay;
    }

    public static RestAssuredDashboardDonutChartDisplayBuilder<?, ?> builder() {
        return new RestAssuredDashboardDonutChartDisplayBuilderImpl();
    }

    public AnalysisStrategyDisplay getStrategyDisplay() {
        return this.strategyDisplay;
    }

    public void setStrategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
        this.strategyDisplay = strategyDisplay;
    }

    public String toString() {
        return "RestAssuredDashboardDonutChartDisplay(strategyDisplay=" + this.getStrategyDisplay() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAssuredDashboardDonutChartDisplay)) {
            return false;
        }
        RestAssuredDashboardDonutChartDisplay other = (RestAssuredDashboardDonutChartDisplay)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AnalysisStrategyDisplay this$strategyDisplay = this.getStrategyDisplay();
        AnalysisStrategyDisplay other$strategyDisplay = other.getStrategyDisplay();
        return !(this$strategyDisplay == null ? other$strategyDisplay != null : !this$strategyDisplay.equals(other$strategyDisplay));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestAssuredDashboardDonutChartDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnalysisStrategyDisplay $strategyDisplay = this.getStrategyDisplay();
        result = result * 59 + ($strategyDisplay == null ? 43 : $strategyDisplay.hashCode());
        return result;
    }

    private static final class RestAssuredDashboardDonutChartDisplayBuilderImpl
    extends RestAssuredDashboardDonutChartDisplayBuilder<RestAssuredDashboardDonutChartDisplay, RestAssuredDashboardDonutChartDisplayBuilderImpl> {
        private RestAssuredDashboardDonutChartDisplayBuilderImpl() {
        }

        @Override
        protected RestAssuredDashboardDonutChartDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public RestAssuredDashboardDonutChartDisplay build() {
            return new RestAssuredDashboardDonutChartDisplay(this);
        }
    }

    public static abstract class RestAssuredDashboardDonutChartDisplayBuilder<C extends RestAssuredDashboardDonutChartDisplay, B extends RestAssuredDashboardDonutChartDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private AnalysisStrategyDisplay strategyDisplay;

        protected abstract B self();

        public abstract C build();

        public B strategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
            this.strategyDisplay = strategyDisplay;
            return (B)this.self();
        }

        public String toString() {
            return "RestAssuredDashboardDonutChartDisplay.RestAssuredDashboardDonutChartDisplayBuilder(super=" + super.toString() + ", strategyDisplay=" + this.strategyDisplay + ")";
        }
    }
}

