/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.reporter.annotation.FileAnnotationStore;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.LogDetailsCollector;
import tech.grasshopper.reporter.tests.markup.RestAssuredTestMarkup;
import tech.grasshopper.reporter.tests.markup.TestMarkup;

public class RestAssuredLogDetailsCollector
extends LogDetailsCollector {
    protected FileAnnotationStore fileAnnotations;

    public AbstractCell createLogDetailCell(Log log) {
        if (log.hasException()) {
            return this.createExceptionCell(log);
        }
        return this.createDetailsMarkupCell(log);
    }

    protected AbstractCell createDetailsMarkupCell(Log log) {
        PDFont LOGS_TABLE_CONTENT_FONT = this.reportFont.getRegularFont();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(LOGS_TABLE_CONTENT_FONT).build();
        if (TestMarkup.isMarkup((String)log.getDetails())) {
            return ((RestAssuredTestMarkup.RestAssuredTestMarkupBuilder)((RestAssuredTestMarkup.RestAssuredTestMarkupBuilder)((RestAssuredTestMarkup.RestAssuredTestMarkupBuilder)((RestAssuredTestMarkup.RestAssuredTestMarkupBuilder)((RestAssuredTestMarkup.RestAssuredTestMarkupBuilder)RestAssuredTestMarkup.builder().log(log)).test(this.test)).reportFont(this.reportFont)).fileAnnotations(this.fileAnnotations).width(this.width - 10.0f)).config(this.config)).build().createMarkupCell();
        }
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(log.getDetails())).font(LOGS_TABLE_CONTENT_FONT)).fontSize(Integer.valueOf(10))).textColor(this.config.statusColor(log.getStatus()))).build();
    }

    protected RestAssuredLogDetailsCollector(RestAssuredLogDetailsCollectorBuilder<?, ?> b) {
        super(b);
        this.fileAnnotations = ((RestAssuredLogDetailsCollectorBuilder)b).fileAnnotations;
    }

    public static RestAssuredLogDetailsCollectorBuilder<?, ?> builder() {
        return new RestAssuredLogDetailsCollectorBuilderImpl();
    }

    public FileAnnotationStore getFileAnnotations() {
        return this.fileAnnotations;
    }

    public void setFileAnnotations(FileAnnotationStore fileAnnotations) {
        this.fileAnnotations = fileAnnotations;
    }

    public String toString() {
        return "RestAssuredLogDetailsCollector(fileAnnotations=" + this.getFileAnnotations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAssuredLogDetailsCollector)) {
            return false;
        }
        RestAssuredLogDetailsCollector other = (RestAssuredLogDetailsCollector)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FileAnnotationStore this$fileAnnotations = this.getFileAnnotations();
        FileAnnotationStore other$fileAnnotations = other.getFileAnnotations();
        return !(this$fileAnnotations == null ? other$fileAnnotations != null : !((Object)this$fileAnnotations).equals(other$fileAnnotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestAssuredLogDetailsCollector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileAnnotationStore $fileAnnotations = this.getFileAnnotations();
        result = result * 59 + ($fileAnnotations == null ? 43 : ((Object)$fileAnnotations).hashCode());
        return result;
    }

    private static final class RestAssuredLogDetailsCollectorBuilderImpl
    extends RestAssuredLogDetailsCollectorBuilder<RestAssuredLogDetailsCollector, RestAssuredLogDetailsCollectorBuilderImpl> {
        private RestAssuredLogDetailsCollectorBuilderImpl() {
        }

        @Override
        protected RestAssuredLogDetailsCollectorBuilderImpl self() {
            return this;
        }

        @Override
        public RestAssuredLogDetailsCollector build() {
            return new RestAssuredLogDetailsCollector(this);
        }
    }

    public static abstract class RestAssuredLogDetailsCollectorBuilder<C extends RestAssuredLogDetailsCollector, B extends RestAssuredLogDetailsCollectorBuilder<C, B>>
    extends LogDetailsCollector.LogDetailsCollectorBuilder<C, B> {
        private FileAnnotationStore fileAnnotations;

        protected abstract B self();

        public abstract C build();

        public B fileAnnotations(FileAnnotationStore fileAnnotations) {
            this.fileAnnotations = fileAnnotations;
            return (B)this.self();
        }

        public String toString() {
            return "RestAssuredLogDetailsCollector.RestAssuredLogDetailsCollectorBuilder(super=" + super.toString() + ", fileAnnotations=" + this.fileAnnotations + ")";
        }
    }
}

