/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.reporter.annotation.FileAnnotationStore;
import tech.grasshopper.reporter.tests.RestAssuredLogDetailsCollector;
import tech.grasshopper.reporter.tests.TestLogsDisplay;

public class RestAssuredTestLogsDisplay
extends TestLogsDisplay {
    protected FileAnnotationStore fileAnnotations;
    private static final float LOGS_DETAILS_WIDTH = 450.0f;

    protected float[] columnsWidth() {
        return new float[]{50.0f, 450.0f - (float)(this.test.getLevel() * 20)};
    }

    protected void tableHeaders(Row.RowBuilder rowBuilder) {
        rowBuilder.add((AbstractCell)TextCell.builder().text("Status").build()).add((AbstractCell)TextCell.builder().text("Log Details").build());
    }

    protected void createLogRows() {
        this.test.getLogs().forEach(l -> {
            AbstractCell detailsCell = this.createLogDisplayCell((Log)l, this.test);
            Row row = Row.builder().padding(5.0f).font(this.reportFont.getRegularFont()).fontSize(Integer.valueOf(10)).add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(l.getStatus().toString())).labelColor(this.config.statusColor(l.getStatus())).build()).add(detailsCell).build();
            this.tableBuilder.addRow(row);
        });
    }

    protected void logRow(Row.RowBuilder rowBuilder, AbstractCell detailsCell, Log l) {
        rowBuilder.add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(l.getStatus().toString())).labelColor(this.config.statusColor(l.getStatus())).build()).add(detailsCell);
    }

    protected AbstractCell createLogDisplayCell(Log log, Test test) {
        return ((RestAssuredLogDetailsCollector.RestAssuredLogDetailsCollectorBuilder)((Object)((RestAssuredLogDetailsCollector.RestAssuredLogDetailsCollectorBuilder)((RestAssuredLogDetailsCollector.RestAssuredLogDetailsCollectorBuilder)((RestAssuredLogDetailsCollector.RestAssuredLogDetailsCollectorBuilder)RestAssuredLogDetailsCollector.builder().config(this.config)).reportFont(this.reportFont)).width(450.0f - (float)(test.getLevel() * 20))).fileAnnotations(this.fileAnnotations))).build().createLogDetailCell(log);
    }

    protected RestAssuredTestLogsDisplay(RestAssuredTestLogsDisplayBuilder<?, ?> b) {
        super(b);
        this.fileAnnotations = ((RestAssuredTestLogsDisplayBuilder)b).fileAnnotations;
    }

    public static RestAssuredTestLogsDisplayBuilder<?, ?> builder() {
        return new RestAssuredTestLogsDisplayBuilderImpl();
    }

    public FileAnnotationStore getFileAnnotations() {
        return this.fileAnnotations;
    }

    public void setFileAnnotations(FileAnnotationStore fileAnnotations) {
        this.fileAnnotations = fileAnnotations;
    }

    public String toString() {
        return "RestAssuredTestLogsDisplay(fileAnnotations=" + this.getFileAnnotations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAssuredTestLogsDisplay)) {
            return false;
        }
        RestAssuredTestLogsDisplay other = (RestAssuredTestLogsDisplay)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FileAnnotationStore this$fileAnnotations = this.getFileAnnotations();
        FileAnnotationStore other$fileAnnotations = other.getFileAnnotations();
        return !(this$fileAnnotations == null ? other$fileAnnotations != null : !((Object)this$fileAnnotations).equals(other$fileAnnotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestAssuredTestLogsDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileAnnotationStore $fileAnnotations = this.getFileAnnotations();
        result = result * 59 + ($fileAnnotations == null ? 43 : ((Object)$fileAnnotations).hashCode());
        return result;
    }

    private static final class RestAssuredTestLogsDisplayBuilderImpl
    extends RestAssuredTestLogsDisplayBuilder<RestAssuredTestLogsDisplay, RestAssuredTestLogsDisplayBuilderImpl> {
        private RestAssuredTestLogsDisplayBuilderImpl() {
        }

        @Override
        protected RestAssuredTestLogsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public RestAssuredTestLogsDisplay build() {
            return new RestAssuredTestLogsDisplay(this);
        }
    }

    public static abstract class RestAssuredTestLogsDisplayBuilder<C extends RestAssuredTestLogsDisplay, B extends RestAssuredTestLogsDisplayBuilder<C, B>>
    extends TestLogsDisplay.TestLogsDisplayBuilder<C, B> {
        private FileAnnotationStore fileAnnotations;

        protected abstract B self();

        public abstract C build();

        public B fileAnnotations(FileAnnotationStore fileAnnotations) {
            this.fileAnnotations = fileAnnotations;
            return (B)this.self();
        }

        public String toString() {
            return "RestAssuredTestLogsDisplay.RestAssuredTestLogsDisplayBuilder(super=" + super.toString() + ", fileAnnotations=" + this.fileAnnotations + ")";
        }
    }
}

