/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.util.ArrayList;
import java.util.logging.Level;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.FileAnnotation;
import tech.grasshopper.pdf.structure.cell.TextFileLinkCell;
import tech.grasshopper.reporter.annotation.FileAnnotationStore;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.TableMarkup;

public class RestAssuredTableMarkup
extends TableMarkup {
    protected FileAnnotationStore fileAnnotations;

    protected float[] columnWidthData(int columnCount) {
        return new float[]{75.0f, 345.0f};
    }

    protected Row createTableCellData(Elements cells) {
        Row.RowBuilder rowBuilder = Row.builder();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
        for (Element cell : cells) {
            AbstractCell cellContent = null;
            try {
                Elements fileElements = cell.select("span");
                ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
                fileElements.forEach(d -> {
                    if (!d.attr("type").isEmpty() && !d.attr("data").isEmpty()) {
                        annotations.add(FileAnnotation.builder().text(d.attr("type")).link(d.attr("data")).build());
                    }
                });
                if (!annotations.isEmpty()) {
                    cellContent = ((TextFileLinkCell.TextFileLinkCellBuilder)((TextFileLinkCell.TextFileLinkCellBuilder)TextFileLinkCell.builder().text(cell.text())).annotations(annotations).textColor(this.textColor)).build();
                    this.fileAnnotations.addFileAnnotations(annotations);
                } else {
                    cellContent = ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(cell.text())).textColor(this.textColor)).lineSpacing(1.0f)).build();
                }
            }
            catch (Exception e) {
                cellContent = this.errorDisplay("Error!");
                logger.log(Level.SEVERE, "Unable to get text for cell, default to error message.");
            }
            rowBuilder.add(cellContent);
        }
        return rowBuilder.build();
    }

    protected RestAssuredTableMarkup(RestAssuredTableMarkupBuilder<?, ?> b) {
        super(b);
        this.fileAnnotations = ((RestAssuredTableMarkupBuilder)b).fileAnnotations;
    }

    public static RestAssuredTableMarkupBuilder<?, ?> builder() {
        return new RestAssuredTableMarkupBuilderImpl();
    }

    public FileAnnotationStore getFileAnnotations() {
        return this.fileAnnotations;
    }

    public void setFileAnnotations(FileAnnotationStore fileAnnotations) {
        this.fileAnnotations = fileAnnotations;
    }

    public String toString() {
        return "RestAssuredTableMarkup(fileAnnotations=" + this.getFileAnnotations() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestAssuredTableMarkup)) {
            return false;
        }
        RestAssuredTableMarkup other = (RestAssuredTableMarkup)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FileAnnotationStore this$fileAnnotations = this.getFileAnnotations();
        FileAnnotationStore other$fileAnnotations = other.getFileAnnotations();
        return !(this$fileAnnotations == null ? other$fileAnnotations != null : !((Object)this$fileAnnotations).equals(other$fileAnnotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestAssuredTableMarkup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileAnnotationStore $fileAnnotations = this.getFileAnnotations();
        result = result * 59 + ($fileAnnotations == null ? 43 : ((Object)$fileAnnotations).hashCode());
        return result;
    }

    private static final class RestAssuredTableMarkupBuilderImpl
    extends RestAssuredTableMarkupBuilder<RestAssuredTableMarkup, RestAssuredTableMarkupBuilderImpl> {
        private RestAssuredTableMarkupBuilderImpl() {
        }

        @Override
        protected RestAssuredTableMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public RestAssuredTableMarkup build() {
            return new RestAssuredTableMarkup(this);
        }
    }

    public static abstract class RestAssuredTableMarkupBuilder<C extends RestAssuredTableMarkup, B extends RestAssuredTableMarkupBuilder<C, B>>
    extends TableMarkup.TableMarkupBuilder<C, B> {
        private FileAnnotationStore fileAnnotations;

        protected abstract B self();

        public abstract C build();

        public B fileAnnotations(FileAnnotationStore fileAnnotations) {
            this.fileAnnotations = fileAnnotations;
            return (B)this.self();
        }

        public String toString() {
            return "RestAssuredTableMarkup.RestAssuredTableMarkupBuilder(super=" + super.toString() + ", fileAnnotations=" + this.fileAnnotations + ")";
        }
    }
}

