/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.annotation;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.destination.Destination;

public class AnnotationProcessor {
    private static final Logger logger = Logger.getLogger(AnnotationProcessor.class.getName());
    @NonNull
    private AnnotationStore annotations;
    @NonNull
    private Destination.DestinationStore destinations;
    protected ExtentPDFReporterConfig config;

    public void processAnnotations() {
        if (this.config.isDisplayAttributeSummary() && this.config.isDisplayAttributeDetails()) {
            this.processAttributeNameAnnotation();
        }
        if (this.config.isDisplayAttributeDetails() && this.config.isDisplayTestDetails()) {
            this.processTestNameAnnotation();
        }
        if (this.config.isDisplayTestDetails() && this.config.isDisplayExpandedMedia()) {
            this.processExpandedMediaAnnotation();
        }
    }

    private void processTestNameAnnotation() {
        this.destinations.getTestDestinations().forEach(d -> {
            List<Annotation> matchedAnnotations = this.annotations.getTestNameAnnotation().stream().filter(a -> a.getId() == d.getId()).collect(Collectors.toList());
            this.processMatchedAnnotations(matchedAnnotations, (Destination)d);
        });
    }

    private void processAttributeNameAnnotation() {
        this.destinations.getAttributeDetailDestinations().forEach(d -> {
            List<Annotation> matchedAnnotations = this.annotations.getAttributeNameAnnotation().stream().filter(a -> a.getTitle().equals(d.getName())).collect(Collectors.toList());
            this.processMatchedAnnotations(matchedAnnotations, (Destination)d);
        });
    }

    private void processExpandedMediaAnnotation() {
        this.destinations.getTestMediaDestinations().forEach(d -> {
            List<Annotation> matchedAnnotations = this.annotations.getTestMediaAnnotation().stream().filter(a -> a.getId() == d.getId()).collect(Collectors.toList());
            this.processMatchedAnnotations(matchedAnnotations, (Destination)d);
        });
        this.destinations.getTestDestinations().forEach(d -> {
            List<Annotation> matchedAnnotations = this.annotations.getTestNameMediaAnnotation().stream().filter(a -> a.getId() == d.getId()).collect(Collectors.toList());
            this.processMatchedAnnotations(matchedAnnotations, (Destination)d);
        });
    }

    private void processMatchedAnnotations(List<Annotation> matchedAnnotation, Destination destination) {
        matchedAnnotation.forEach(a -> {
            PDActionGoTo action = new PDActionGoTo();
            action.setDestination((PDDestination)destination.createPDPageDestination());
            PDAnnotationLink annotationLink = a.createPDAnnotationLink();
            annotationLink.setAction((PDAction)action);
            try {
                a.getPage().getAnnotations().add(annotationLink);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to create annotation link", e);
            }
        });
    }

    AnnotationProcessor(@NonNull AnnotationStore annotations, @NonNull Destination.DestinationStore destinations, ExtentPDFReporterConfig config) {
        if (annotations == null) {
            throw new NullPointerException("annotations is marked non-null but is null");
        }
        if (destinations == null) {
            throw new NullPointerException("destinations is marked non-null but is null");
        }
        this.annotations = annotations;
        this.destinations = destinations;
        this.config = config;
    }

    public static AnnotationProcessorBuilder builder() {
        return new AnnotationProcessorBuilder();
    }

    @NonNull
    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    @NonNull
    public Destination.DestinationStore getDestinations() {
        return this.destinations;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    public void setAnnotations(@NonNull AnnotationStore annotations) {
        if (annotations == null) {
            throw new NullPointerException("annotations is marked non-null but is null");
        }
        this.annotations = annotations;
    }

    public void setDestinations(@NonNull Destination.DestinationStore destinations) {
        if (destinations == null) {
            throw new NullPointerException("destinations is marked non-null but is null");
        }
        this.destinations = destinations;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationProcessor)) {
            return false;
        }
        AnnotationProcessor other = (AnnotationProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Destination.DestinationStore this$destinations = this.getDestinations();
        Destination.DestinationStore other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Destination.DestinationStore $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        return result;
    }

    public String toString() {
        return "AnnotationProcessor(annotations=" + this.getAnnotations() + ", destinations=" + this.getDestinations() + ", config=" + (Object)((Object)this.getConfig()) + ")";
    }

    public static class AnnotationProcessorBuilder {
        private AnnotationStore annotations;
        private Destination.DestinationStore destinations;
        private ExtentPDFReporterConfig config;

        AnnotationProcessorBuilder() {
        }

        public AnnotationProcessorBuilder annotations(@NonNull AnnotationStore annotations) {
            if (annotations == null) {
                throw new NullPointerException("annotations is marked non-null but is null");
            }
            this.annotations = annotations;
            return this;
        }

        public AnnotationProcessorBuilder destinations(@NonNull Destination.DestinationStore destinations) {
            if (destinations == null) {
                throw new NullPointerException("destinations is marked non-null but is null");
            }
            this.destinations = destinations;
            return this;
        }

        public AnnotationProcessorBuilder config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this;
        }

        public AnnotationProcessor build() {
            return new AnnotationProcessor(this.annotations, this.destinations, this.config);
        }

        public String toString() {
            return "AnnotationProcessor.AnnotationProcessorBuilder(annotations=" + this.annotations + ", destinations=" + this.destinations + ", config=" + (Object)((Object)this.config) + ")";
        }
    }
}

