/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.annotation;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import tech.grasshopper.reporter.annotation.AnnotationStore;

public class FileAnnotationProcessor {
    private PDDocument document;
    @NonNull
    private AnnotationStore annotations;
    private static final Logger logger = Logger.getLogger(FileAnnotationProcessor.class.getName());

    public void updateAttachments() {
        this.annotations.getTestMediaFileAnnotation().forEach(f -> {
            try {
                PDAnnotationFileAttachment fileAtt = new PDAnnotationFileAttachment();
                fileAtt.setRectangle(f.getRectangle());
                PDColor pdColor = new PDColor(new float[]{0.5f, 0.5f, 0.5f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
                fileAtt.setColor(pdColor);
                PDEmbeddedFile ef = new PDEmbeddedFile(this.document, (InputStream)new FileInputStream(f.getLink()));
                ef.setModDate((Calendar)new GregorianCalendar());
                ef.setCreationDate((Calendar)new GregorianCalendar());
                PDComplexFileSpecification fs = new PDComplexFileSpecification();
                fs.setEmbeddedFile(ef);
                fs.setFile(f.getLink());
                fs.setFileUnicode(f.getLink());
                fileAtt.setFile((PDFileSpecification)fs);
                f.getPage().getAnnotations().add(fileAtt);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unable to create file annotation link", ex);
            }
        });
    }

    FileAnnotationProcessor(PDDocument document, @NonNull AnnotationStore annotations) {
        if (annotations == null) {
            throw new NullPointerException("annotations is marked non-null but is null");
        }
        this.document = document;
        this.annotations = annotations;
    }

    public static FileAnnotationProcessorBuilder builder() {
        return new FileAnnotationProcessorBuilder();
    }

    public static class FileAnnotationProcessorBuilder {
        private PDDocument document;
        private AnnotationStore annotations;

        FileAnnotationProcessorBuilder() {
        }

        public FileAnnotationProcessorBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public FileAnnotationProcessorBuilder annotations(@NonNull AnnotationStore annotations) {
            if (annotations == null) {
                throw new NullPointerException("annotations is marked non-null but is null");
            }
            this.annotations = annotations;
            return this;
        }

        public FileAnnotationProcessor build() {
            return new FileAnnotationProcessor(this.document, this.annotations);
        }

        public String toString() {
            return "FileAnnotationProcessor.FileAnnotationProcessorBuilder(document=" + this.document + ", annotations=" + this.annotations + ")";
        }
    }
}

