/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.context;

import tech.grasshopper.reporter.context.AttributeSummaryDisplay;
import tech.grasshopper.reporter.context.AttributeType;
import tech.grasshopper.reporter.context.ContextAttributeSummary;
import tech.grasshopper.reporter.context.SystemAttributeSummary;
import tech.grasshopper.reporter.header.PageHeaderAware;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.Section;

public class AttributeSummary
extends Section
implements PageHeaderAware {
    private float destinationYLocation;

    @Override
    public void createSection() {
        if (!this.checkDataValidity()) {
            return;
        }
        this.pageHeaderDetails();
        this.createPage();
        AttributeSummaryDisplay categories = ((ContextAttributeSummary.ContextAttributeSummaryBuilder)((Display.DisplayBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)ContextAttributeSummary.builder().config(this.config)).document(this.document)).type(AttributeType.CATEGORY)).report(this.report)).reportFont(this.reportFont)).annotations(this.annotations)).ylocation(this.destinationYLocation)).build();
        ((ContextAttributeSummary)categories).display();
        if (this.report.getCategoryCtx().hasItems()) {
            this.createAttributeDestination(categories);
        }
        AttributeSummaryDisplay authors = ((ContextAttributeSummary.ContextAttributeSummaryBuilder)((Display.DisplayBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)ContextAttributeSummary.builder().config(this.config)).document(this.document)).type(AttributeType.AUTHOR)).report(this.report)).reportFont(this.reportFont)).annotations(this.annotations)).ylocation(categories.getYlocation())).build();
        ((ContextAttributeSummary)authors).display();
        if (this.report.getAuthorCtx().hasItems()) {
            this.createAttributeDestination(authors);
        }
        AttributeSummaryDisplay devices = ((ContextAttributeSummary.ContextAttributeSummaryBuilder)((Display.DisplayBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)((ContextAttributeSummary.ContextAttributeSummaryBuilder)ContextAttributeSummary.builder().config(this.config)).document(this.document)).type(AttributeType.DEVICE)).report(this.report)).reportFont(this.reportFont)).annotations(this.annotations)).ylocation(authors.getYlocation())).build();
        ((ContextAttributeSummary)devices).display();
        if (this.report.getDeviceCtx().hasItems()) {
            this.createAttributeDestination(devices);
        }
        AttributeSummaryDisplay systems = ((SystemAttributeSummary.SystemAttributeSummaryBuilder)((SystemAttributeSummary.SystemAttributeSummaryBuilder)((SystemAttributeSummary.SystemAttributeSummaryBuilder)((SystemAttributeSummary.SystemAttributeSummaryBuilder)((SystemAttributeSummary.SystemAttributeSummaryBuilder)((SystemAttributeSummary.SystemAttributeSummaryBuilder)SystemAttributeSummary.builder().config(this.config)).document(this.document)).type(AttributeType.SYSTEM)).report(this.report)).reportFont(this.reportFont)).ylocation(devices.getYlocation())).build();
        ((SystemAttributeSummary)systems).display();
        if (!this.report.getSystemEnvInfo().isEmpty()) {
            this.createAttributeDestination(systems);
        }
    }

    private void createAttributeDestination(AttributeSummaryDisplay summaryDisplay) {
        this.destinations.addAttributeSummaryDestination(summaryDisplay.createDestination());
    }

    @Override
    public String getSectionTitle() {
        return "ATTRIBUTE SUMMARY";
    }

    private boolean checkDataValidity() {
        return this.report.getCategoryCtx().hasItems() || this.report.getAuthorCtx().hasItems() || this.report.getDeviceCtx().hasItems() || !this.report.getSystemEnvInfo().isEmpty();
    }

    private static float $default$destinationYLocation() {
        return 790.0f;
    }

    protected AttributeSummary(AttributeSummaryBuilder<?, ?> b) {
        super(b);
        this.destinationYLocation = ((AttributeSummaryBuilder)b).destinationYLocation$set ? ((AttributeSummaryBuilder)b).destinationYLocation$value : AttributeSummary.$default$destinationYLocation();
    }

    public static AttributeSummaryBuilder<?, ?> builder() {
        return new AttributeSummaryBuilderImpl();
    }

    public float getDestinationYLocation() {
        return this.destinationYLocation;
    }

    public void setDestinationYLocation(float destinationYLocation) {
        this.destinationYLocation = destinationYLocation;
    }

    @Override
    public String toString() {
        return "AttributeSummary(destinationYLocation=" + this.getDestinationYLocation() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeSummary)) {
            return false;
        }
        AttributeSummary other = (AttributeSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getDestinationYLocation(), other.getDestinationYLocation()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeSummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDestinationYLocation());
        return result;
    }

    private static final class AttributeSummaryBuilderImpl
    extends AttributeSummaryBuilder<AttributeSummary, AttributeSummaryBuilderImpl> {
        private AttributeSummaryBuilderImpl() {
        }

        @Override
        protected AttributeSummaryBuilderImpl self() {
            return this;
        }

        @Override
        public AttributeSummary build() {
            return new AttributeSummary(this);
        }
    }

    public static abstract class AttributeSummaryBuilder<C extends AttributeSummary, B extends AttributeSummaryBuilder<C, B>>
    extends Section.SectionBuilder<C, B> {
        private boolean destinationYLocation$set;
        private float destinationYLocation$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B destinationYLocation(float destinationYLocation) {
            this.destinationYLocation$value = destinationYLocation;
            this.destinationYLocation$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AttributeSummary.AttributeSummaryBuilder(super=" + super.toString() + ", destinationYLocation$value=" + this.destinationYLocation$value + ")";
        }
    }
}

