/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.context;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.reporter.context.AttributeSummaryDisplay;

public class SystemAttributeSummary
extends AttributeSummaryDisplay {
    private static final float HEADER_NAME_WIDTH = 225.0f;
    private static final float HEADER_VALUE_WIDTH = 275.0f;
    private Map<String, String> data;

    @Override
    public void display() {
        this.data = this.systemAttributeData();
        if (this.data.isEmpty()) {
            return;
        }
        this.createTableBuilder();
        this.createTitleRow();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{225.0f, 275.0f}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).verticalAlignment(VerticalAlignment.TOP).horizontalAlignment(HorizontalAlignment.LEFT);
    }

    private void createTitleRow() {
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(25.0f)).font(this.reportFont.getBoldItalicFont()).fontSize(Integer.valueOf(15)).borderWidth(0.0f).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.type.toString()).textColor(this.config.getSystemTitleColor())).colSpan(2)).build()).build());
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().font(this.reportFont.getBoldItalicFont()).fontSize(Integer.valueOf(13)).height(Float.valueOf(25.0f)).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Name").textColor(this.config.getSystemNameColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Value").textColor(this.config.getSystemValueColor())).build()).build());
    }

    private void createDataRows() {
        this.data.forEach((k, v) -> {
            Row row = Row.builder().font(this.TABLE_CONTENT_FONT).fontSize(Integer.valueOf(12)).wordBreak(Boolean.valueOf(true)).padding(7.0f).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.textSanitizer.sanitizeText((String)k)).textColor(this.config.getSystemNameColor())).lineSpacing(1.0f)).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.textSanitizer.sanitizeText((String)v)).textColor(this.config.getSystemValueColor())).lineSpacing(1.0f)).build()).build();
            this.tableBuilder.addRow(row);
        });
    }

    private static Map<String, String> $default$data() {
        return new LinkedHashMap<String, String>();
    }

    protected SystemAttributeSummary(SystemAttributeSummaryBuilder<?, ?> b) {
        super((AttributeSummaryDisplay.AttributeSummaryDisplayBuilder<?, ?>)b);
        this.data = ((SystemAttributeSummaryBuilder)b).data$set ? ((SystemAttributeSummaryBuilder)b).data$value : SystemAttributeSummary.$default$data();
    }

    public static SystemAttributeSummaryBuilder<?, ?> builder() {
        return new SystemAttributeSummaryBuilderImpl();
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "SystemAttributeSummary(data=" + this.getData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemAttributeSummary)) {
            return false;
        }
        SystemAttributeSummary other = (SystemAttributeSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$data = this.getData();
        Map<String, String> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SystemAttributeSummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    private static final class SystemAttributeSummaryBuilderImpl
    extends SystemAttributeSummaryBuilder<SystemAttributeSummary, SystemAttributeSummaryBuilderImpl> {
        private SystemAttributeSummaryBuilderImpl() {
        }

        @Override
        protected SystemAttributeSummaryBuilderImpl self() {
            return this;
        }

        @Override
        public SystemAttributeSummary build() {
            return new SystemAttributeSummary(this);
        }
    }

    public static abstract class SystemAttributeSummaryBuilder<C extends SystemAttributeSummary, B extends SystemAttributeSummaryBuilder<C, B>>
    extends AttributeSummaryDisplay.AttributeSummaryDisplayBuilder<C, B> {
        private boolean data$set;
        private Map<String, String> data$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B data(Map<String, String> data) {
            this.data$value = data;
            this.data$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SystemAttributeSummary.SystemAttributeSummaryBuilder(super=" + super.toString() + ", data$value=" + this.data$value + ")";
        }
    }
}

