/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.context.detail;

import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.context.NamedAttributeContext;
import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.util.DateUtil;

public class AttributeTestStatusDetailsDisplay
extends Display {
    private static final float HEADER_HEIGHT = 25.0f;
    private static final float TABLE_GAP_HEIGHT = 15.0f;
    private static final int HEADER_FONT_SIZE = 13;
    private static final float HEADER_PADDING_WIDTH = 5.0f;
    private static final float HEADER_STATUS_WIDTH = 55.0f;
    private static final float HEADER_TIMESTAMP_WIDTH = 85.0f;
    private static final float HEADER_TESTNAME_WIDTH = 360.0f;
    private static final float TABLE_BORDER_WIDTH = 1.0f;
    private static final int TABLE_CONTENT_FONT_SIZE = 11;
    private static final float TABLE_CONTENT_COLUMN_PADDING = 7.0f;
    private static final float MULTILINE_SPACING = 1.0f;
    protected NamedAttributeContext<? extends NamedAttribute> attribute;
    protected Table.TableBuilder tableBuilder;
    protected AnnotationStore annotations;

    @Override
    public void display() {
        this.createTestTableBuilder();
        this.createTestHeaderRow();
        this.createTestDataRows();
        this.drawTestDetailsTable();
    }

    private void createTestTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{55.0f, 85.0f, 360.0f}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP);
    }

    private void createTestHeaderRow() {
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(25.0f)).font(this.reportFont.getBoldItalicFont()).fontSize(Integer.valueOf(13)).add((AbstractCell)TextCell.builder().text("Status").build()).add((AbstractCell)TextCell.builder().text("Timestamp").build()).add((AbstractCell)TextCell.builder().text("Test Name").build()).build());
    }

    private void createTestDataRows() {
        PDFont tableContentFont = this.reportFont.getRegularFont();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(tableContentFont).build();
        this.attribute.getTestList().forEach(t -> {
            Annotation annotation = Annotation.builder().id(t.getId()).build();
            this.annotations.addTestNameAnnotation(annotation);
            Row row = Row.builder().font(tableContentFont).fontSize(Integer.valueOf(11)).wordBreak(Boolean.valueOf(true)).padding(7.0f).add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(t.getStatus().toString())).labelColor(this.config.statusColor(t.getStatus())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.formatTimeAMPM(DateUtil.convertToLocalDateTimeFromDate(t.getStartTime()))).textColor(this.config.getTestTimeStampColor())).build()).add(this.createTestNameCell(textSanitizer.sanitizeText(t.getName()), this.config.statusColor(t.getStatus()), annotation)).build();
            this.tableBuilder.addRow(row);
        });
    }

    private void drawTestDetailsTable() {
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(1).splitRow(true).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 15.0f;
    }

    private AbstractCell createTestNameCell(String title, Color statusColor, Annotation annotation) {
        if (this.config.isDisplayTestDetails()) {
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().annotation(annotation).text(title)).textColor(statusColor)).lineSpacing(1.0f)).build();
        }
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(title).textColor(statusColor)).lineSpacing(1.0f)).build();
    }

    protected AttributeTestStatusDetailsDisplay(AttributeTestStatusDetailsDisplayBuilder<?, ?> b) {
        super(b);
        this.attribute = ((AttributeTestStatusDetailsDisplayBuilder)b).attribute;
        this.tableBuilder = ((AttributeTestStatusDetailsDisplayBuilder)b).tableBuilder;
        this.annotations = ((AttributeTestStatusDetailsDisplayBuilder)b).annotations;
    }

    public static AttributeTestStatusDetailsDisplayBuilder<?, ?> builder() {
        return new AttributeTestStatusDetailsDisplayBuilderImpl();
    }

    public NamedAttributeContext<? extends NamedAttribute> getAttribute() {
        return this.attribute;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setAttribute(NamedAttributeContext<? extends NamedAttribute> attribute) {
        this.attribute = attribute;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "AttributeTestStatusDetailsDisplay(attribute=" + this.getAttribute() + ", tableBuilder=" + this.getTableBuilder() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeTestStatusDetailsDisplay)) {
            return false;
        }
        AttributeTestStatusDetailsDisplay other = (AttributeTestStatusDetailsDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NamedAttributeContext<? extends NamedAttribute> this$attribute = this.getAttribute();
        NamedAttributeContext<? extends NamedAttribute> other$attribute = other.getAttribute();
        if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeTestStatusDetailsDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NamedAttributeContext<? extends NamedAttribute> $attribute = this.getAttribute();
        result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class AttributeTestStatusDetailsDisplayBuilderImpl
    extends AttributeTestStatusDetailsDisplayBuilder<AttributeTestStatusDetailsDisplay, AttributeTestStatusDetailsDisplayBuilderImpl> {
        private AttributeTestStatusDetailsDisplayBuilderImpl() {
        }

        @Override
        protected AttributeTestStatusDetailsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public AttributeTestStatusDetailsDisplay build() {
            return new AttributeTestStatusDetailsDisplay(this);
        }
    }

    public static abstract class AttributeTestStatusDetailsDisplayBuilder<C extends AttributeTestStatusDetailsDisplay, B extends AttributeTestStatusDetailsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private NamedAttributeContext<? extends NamedAttribute> attribute;
        private Table.TableBuilder tableBuilder;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B attribute(NamedAttributeContext<? extends NamedAttribute> attribute) {
            this.attribute = attribute;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AttributeTestStatusDetailsDisplay.AttributeTestStatusDetailsDisplayBuilder(super=" + super.toString() + ", attribute=" + this.attribute + ", tableBuilder=" + this.tableBuilder + ", annotations=" + this.annotations + ")";
        }
    }
}

