/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import tech.grasshopper.reporter.exception.PdfReportException;

public class ReportFont {
    private static final Logger logger = Logger.getLogger(ReportFont.class.getName());
    private PDFont regularFont;
    private PDFont boldFont;
    private PDFont italicFont;
    private PDFont boldItalicFont;
    private static final String FONT_FOLDER = "/tech/grasshopper/ttf/";

    public ReportFont(PDDocument document) {
        this.loadReportFontFamily(document);
    }

    private void loadReportFontFamily(PDDocument document) {
        try {
            this.regularFont = PDType0Font.load((PDDocument)document, (InputStream)ReportFont.class.getResourceAsStream("/tech/grasshopper/ttf/LiberationSans-Regular.ttf"));
            this.boldFont = PDType0Font.load((PDDocument)document, (InputStream)ReportFont.class.getResourceAsStream("/tech/grasshopper/ttf/LiberationSans-Bold.ttf"));
            this.italicFont = PDType0Font.load((PDDocument)document, (InputStream)ReportFont.class.getResourceAsStream("/tech/grasshopper/ttf/LiberationSans-Italic.ttf"));
            this.boldItalicFont = PDType0Font.load((PDDocument)document, (InputStream)ReportFont.class.getResourceAsStream("/tech/grasshopper/ttf/LiberationSans-BoldItalic.ttf"));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to load report font - LiberationSans. The 'ttf' files should be available in '/tech/grasshopper/ttf' folder.", e);
            throw new PdfReportException(e);
        }
    }

    public String toString() {
        return this.regularFont.getName() + " - " + this.boldFont.getName() + " - " + this.italicFont.getName() + " - " + this.boldItalicFont.getName();
    }

    public PDFont getRegularFont() {
        return this.regularFont;
    }

    public PDFont getBoldFont() {
        return this.boldFont;
    }

    public PDFont getItalicFont() {
        return this.italicFont;
    }

    public PDFont getBoldItalicFont() {
        return this.boldItalicFont;
    }
}

