/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.medias;

import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.service.MediaService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.cell.ImageCell;

public abstract class Medias {
    protected Media media;
    protected PDDocument document;
    protected PDImageXObject image;
    protected String[] locations;
    protected float padding;
    protected boolean imageNotAvailable = false;
    protected static PDImageXObject imageNotFound = null;

    private void initializeNotFoundImage() throws IOException {
        if (imageNotFound == null) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("not-found-image.png");
            byte[] targetArray = new byte[is.available()];
            is.read(targetArray);
            imageNotFound = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])targetArray, (String)"not-found-image");
        }
    }

    private void generatePDImage() throws IOException {
        if (MediaService.isBase64((Media)this.media)) {
            this.image = imageNotFound;
        } else {
            String path = this.media.getResolvedPath();
            if (path == null || path.isEmpty()) {
                path = this.media.getPath();
            }
            if (!new File(path).exists()) {
                MediaService.tryResolveMediaPath((Media)this.media, (String[])this.locations);
                if (this.media.getResolvedPath() != null) {
                    path = this.media.getResolvedPath();
                }
            }
            this.image = PDImageXObject.createFromFile((String)path, (PDDocument)this.document);
        }
    }

    protected PDImageXObject processPDImage() {
        try {
            this.initializeNotFoundImage();
            this.generatePDImage();
        }
        catch (Exception e) {
            this.image = imageNotFound;
            this.imageNotAvailable = true;
        }
        return this.image;
    }

    public abstract ImageCell createImageCell();

    protected Medias(MediasBuilder<?, ?> b) {
        this.media = ((MediasBuilder)b).media;
        this.document = ((MediasBuilder)b).document;
        this.image = ((MediasBuilder)b).image;
        this.locations = ((MediasBuilder)b).locations;
        this.padding = ((MediasBuilder)b).padding;
        this.imageNotAvailable = ((MediasBuilder)b).imageNotAvailable;
    }

    public boolean isImageNotAvailable() {
        return this.imageNotAvailable;
    }

    public static abstract class MediasBuilder<C extends Medias, B extends MediasBuilder<C, B>> {
        private Media media;
        private PDDocument document;
        private PDImageXObject image;
        private String[] locations;
        private float padding;
        private boolean imageNotAvailable;

        protected abstract B self();

        public abstract C build();

        public B media(Media media) {
            this.media = media;
            return this.self();
        }

        public B document(PDDocument document) {
            this.document = document;
            return this.self();
        }

        public B image(PDImageXObject image) {
            this.image = image;
            return this.self();
        }

        public B locations(String[] locations) {
            this.locations = locations;
            return this.self();
        }

        public B padding(float padding) {
            this.padding = padding;
            return this.self();
        }

        public B imageNotAvailable(boolean imageNotAvailable) {
            this.imageNotAvailable = imageNotAvailable;
            return this.self();
        }

        public String toString() {
            return "Medias.MediasBuilder(media=" + this.media + ", document=" + this.document + ", image=" + this.image + ", locations=" + Arrays.deepToString(this.locations) + ", padding=" + this.padding + ", imageNotAvailable=" + this.imageNotAvailable + ")";
        }
    }
}

