/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.header.PageHeaderAware;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.Section;
import tech.grasshopper.reporter.tests.TestBDDExecutableDisplay;
import tech.grasshopper.reporter.tests.TestBasicDetailsDisplay;

public class TestBDDDetails
extends Section
implements PageHeaderAware {
    public static final int LEVEL_X_INDENT = 20;
    private float yLocation;
    private Destination destination;

    @Override
    public void createSection() {
        if (this.report.getTestList().isEmpty()) {
            return;
        }
        this.pageHeaderDetails();
        this.createPage();
        for (Test level0Test : this.report.getTestList()) {
            this.displayBasicTestDetails(level0Test);
            for (Test level1Test : level0Test.getChildren()) {
                boolean isSO = level1Test.getBddType() == ScenarioOutline.class;
                this.displayBasicTestDetails(level1Test);
                if (!isSO && level1Test.hasChildren()) {
                    this.displayExecutableTestDetailsAndCreateHiddenTestDestination(level1Test);
                    continue;
                }
                for (Test level2Test : level1Test.getChildren()) {
                    this.displayBasicTestDetails(level2Test);
                    if (!level2Test.hasChildren()) continue;
                    this.displayExecutableTestDetailsAndCreateHiddenTestDestination(level2Test);
                }
            }
        }
    }

    private void displayBasicTestDetails(Test test) {
        Display testBasicDetailsDisplay = ((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)((Display.DisplayBuilder)((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)TestBasicDetailsDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).ylocation(this.yLocation)).build();
        ((TestBasicDetailsDisplay)testBasicDetailsDisplay).display();
        this.createTestDestination((TestBasicDetailsDisplay)testBasicDetailsDisplay);
        this.yLocation = testBasicDetailsDisplay.getYlocation();
    }

    private void displayExecutableTestDetailsAndCreateHiddenTestDestination(Test test) {
        Display executableDisplay = ((TestBDDExecutableDisplay.TestBDDExecutableDisplayBuilder)((TestBDDExecutableDisplay.TestBDDExecutableDisplayBuilder)((TestBDDExecutableDisplay.TestBDDExecutableDisplayBuilder)((TestBDDExecutableDisplay.TestBDDExecutableDisplayBuilder)((TestBDDExecutableDisplay.TestBDDExecutableDisplayBuilder)((Display.DisplayBuilder)TestBDDExecutableDisplay.builder().test(test)).document(this.document)).reportFont(this.reportFont)).config(this.config)).ylocation(this.yLocation)).annotations(this.annotations)).build();
        ((TestBDDExecutableDisplay)executableDisplay).display();
        this.yLocation = executableDisplay.getYlocation();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.reportFont.getRegularFont()).build();
        ArrayList<Test> childTests = new ArrayList<Test>();
        this.collectTestNodes(test, childTests);
        childTests.forEach(t -> this.destinations.addTestDestination(Destination.builder().id(t.getId()).name(textSanitizer.sanitizeText(t.getName())).yCoord(this.destination.getYCoord()).page(this.destination.getPage()).build()));
    }

    private void collectTestNodes(Test test, List<Test> tests) {
        test.getChildren().forEach(t -> {
            tests.add((Test)t);
            this.collectTestNodes((Test)t, tests);
        });
    }

    private void createTestDestination(TestBasicDetailsDisplay testDisplay) {
        this.destination = testDisplay.createDestination();
        this.destinations.addTestDestination(this.destination);
        if (testDisplay.getTest().getLevel() == 0) {
            this.destinations.addTopLevelTestDestination(this.destination);
        }
    }

    @Override
    public String getSectionTitle() {
        return "TEST DETAILS";
    }

    private static float $default$yLocation() {
        return 790.0f;
    }

    protected TestBDDDetails(TestBDDDetailsBuilder<?, ?> b) {
        super(b);
        this.yLocation = ((TestBDDDetailsBuilder)b).yLocation$set ? ((TestBDDDetailsBuilder)b).yLocation$value : TestBDDDetails.$default$yLocation();
        this.destination = ((TestBDDDetailsBuilder)b).destination;
    }

    public static TestBDDDetailsBuilder<?, ?> builder() {
        return new TestBDDDetailsBuilderImpl();
    }

    public float getYLocation() {
        return this.yLocation;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setYLocation(float yLocation) {
        this.yLocation = yLocation;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    @Override
    public String toString() {
        return "TestBDDDetails(yLocation=" + this.getYLocation() + ", destination=" + this.getDestination() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestBDDDetails)) {
            return false;
        }
        TestBDDDetails other = (TestBDDDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYLocation(), other.getYLocation()) != 0) {
            return false;
        }
        Destination this$destination = this.getDestination();
        Destination other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestBDDDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYLocation());
        Destination $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        return result;
    }

    private static final class TestBDDDetailsBuilderImpl
    extends TestBDDDetailsBuilder<TestBDDDetails, TestBDDDetailsBuilderImpl> {
        private TestBDDDetailsBuilderImpl() {
        }

        @Override
        protected TestBDDDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public TestBDDDetails build() {
            return new TestBDDDetails(this);
        }
    }

    public static abstract class TestBDDDetailsBuilder<C extends TestBDDDetails, B extends TestBDDDetailsBuilder<C, B>>
    extends Section.SectionBuilder<C, B> {
        private boolean yLocation$set;
        private float yLocation$value;
        private Destination destination;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B yLocation(float yLocation) {
            this.yLocation$value = yLocation;
            this.yLocation$set = true;
            return (B)this.self();
        }

        public B destination(Destination destination) {
            this.destination = destination;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestBDDDetails.TestBDDDetailsBuilder(super=" + super.toString() + ", yLocation$value=" + this.yLocation$value + ", destination=" + this.destination + ")";
        }
    }
}

