/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Test;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.reporter.context.AttributeType;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.destination.DestinationAware;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.TestIndent;
import tech.grasshopper.reporter.util.DateUtil;

public class TestBasicDetailsDisplay
extends Display
implements TestIndent,
DestinationAware {
    private final PDFont CONTENT_FONT;
    private static final int NAME_FONT_SIZE = 15;
    private static final int DESCRIPTION_FONT_SIZE = 11;
    private static final int TIMES_FONT_SIZE = 12;
    private static final int ATTRIBUTE_FONT_SIZE = 12;
    private static final float PADDING = 5.0f;
    private static final float NAME_WIDTH = 450.0f;
    private static final float STATUS_WIDTH = 50.0f;
    private static final float NAME_HEIGHT = 20.0f;
    private static final float DESCRIPTION_HEIGHT = 20.0f;
    private static final float TIMES_HEIGHT = 20.0f;
    private static final float ATTRIBUTE_HEIGHT = 20.0f;
    private static final float GAP_HEIGHT = 5.0f;
    private static final float BORDER_WIDTH = 0.0f;
    private static final float MULTI_LINE_SPACING = 1.0f;
    protected Test test;
    private Table.TableBuilder tableBuilder;
    private int destinationY;
    protected final TextSanitizer textSanitizer;

    @Override
    public void display() {
        this.xlocation += (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20);
        this.createTableBuilder();
        this.createNameRow();
        this.createDurationRow();
        this.createAttributesRow();
        this.createDescriptionRow();
        this.drawTable();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{450.0f - (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20), 50.0f}).padding(5.0f).borderWidth(0.0f).font(this.reportFont.getBoldItalicFont()).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.MIDDLE);
    }

    private void createNameRow() {
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(20.0f)).fontSize(Integer.valueOf(15))).text(this.textSanitizer.sanitizeText(this.test.getName())).lineSpacing(1.0f)).textColor(this.config.getTestNameColor())).build()).add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(this.test.getStatus().toString())).labelColor(this.config.statusColor(this.test.getStatus())).fontSize(Integer.valueOf(12))).font(this.reportFont.getBoldFont())).padding(0.0f)).verticalAlignment(VerticalAlignment.TOP)).build()).build());
    }

    private void createDurationRow() {
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(20.0f)).fontSize(Integer.valueOf(12))).text(this.testDuration()).textColor(this.config.getTestTimesColor())).colSpan(2)).build()).build());
    }

    private String testDuration() {
        LocalDateTime start = DateUtil.convertToLocalDateTimeFromDate(this.test.getStartTime());
        LocalDateTime end = DateUtil.convertToLocalDateTimeFromDate(this.test.getEndTime());
        String duration = "/ " + DateUtil.formatDateTimeWithMillis(start) + " / " + DateUtil.formatDateTimeWithMillis(end) + " / " + DateUtil.durationValue(start, end) + " /";
        if (this.test.getLevel() > 0) {
            duration = " / " + DateUtil.durationValue(start, end) + " /";
        }
        return duration;
    }

    private void createAttributesRow() {
        if (this.test.getCategorySet().isEmpty() && this.test.getAuthorSet().isEmpty() && this.test.getDeviceSet().isEmpty()) {
            return;
        }
        ParagraphCell.Paragraph.ParagraphBuilder paraBuilder = ParagraphCell.Paragraph.builder();
        this.createAttributeText(this.test.getCategorySet(), AttributeType.CATEGORY, paraBuilder);
        this.createAttributeText(this.test.getAuthorSet(), AttributeType.AUTHOR, paraBuilder);
        this.createAttributeText(this.test.getDeviceSet(), AttributeType.DEVICE, paraBuilder);
        this.tableBuilder.addRow(Row.builder().fontSize(Integer.valueOf(12)).add((AbstractCell)((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paragraph(paraBuilder.build()).minHeight(20.0f)).lineSpacing(1.0f).colSpan(2)).build()).build());
    }

    private void createAttributeText(Set<? extends NamedAttribute> attributes, AttributeType type, ParagraphCell.Paragraph.ParagraphBuilder paraBuilder) {
        if (!attributes.isEmpty()) {
            String atts = attributes.stream().map(a -> this.textSanitizer.sanitizeText(a.getName())).collect(Collectors.joining(" / ", "/ ", " /"));
            paraBuilder.append(StyledText.builder().text(atts).color(this.config.attributeHeaderColor(type)).build());
        }
    }

    private void createDescriptionRow() {
        if (this.test.getDescription() != null && !this.test.getDescription().isEmpty()) {
            this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(20.0f)).fontSize(Integer.valueOf(11))).text(this.textSanitizer.sanitizeText(this.test.getDescription())).lineSpacing(1.0f)).textColor(this.config.getTestDescriptionColor())).colSpan(2)).build()).build());
        }
    }

    private void drawTable() {
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(0).splitRow(true).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 5.0f;
        this.page = table.getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 790;
        }
    }

    @Override
    public Destination createDestination() {
        return Destination.builder().id(this.test.getId()).name(this.textSanitizer.sanitizeText(this.test.getName())).yCoord(this.destinationY).page(this.page).build();
    }

    protected TestBasicDetailsDisplay(TestBasicDetailsDisplayBuilder<?, ?> b) {
        super(b);
        this.CONTENT_FONT = this.reportFont.getBoldItalicFont();
        this.textSanitizer = TextSanitizer.builder().font(this.CONTENT_FONT).build();
        this.test = ((TestBasicDetailsDisplayBuilder)b).test;
        this.tableBuilder = ((TestBasicDetailsDisplayBuilder)b).tableBuilder;
        this.destinationY = ((TestBasicDetailsDisplayBuilder)b).destinationY;
    }

    public static TestBasicDetailsDisplayBuilder<?, ?> builder() {
        return new TestBasicDetailsDisplayBuilderImpl();
    }

    public PDFont getCONTENT_FONT() {
        return this.CONTENT_FONT;
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    @Override
    public String toString() {
        return "TestBasicDetailsDisplay(CONTENT_FONT=" + this.getCONTENT_FONT() + ", test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ", destinationY=" + this.getDestinationY() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestBasicDetailsDisplay)) {
            return false;
        }
        TestBasicDetailsDisplay other = (TestBasicDetailsDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        PDFont this$CONTENT_FONT = this.getCONTENT_FONT();
        PDFont other$CONTENT_FONT = other.getCONTENT_FONT();
        if (this$CONTENT_FONT == null ? other$CONTENT_FONT != null : !this$CONTENT_FONT.equals(other$CONTENT_FONT)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestBasicDetailsDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDestinationY();
        PDFont $CONTENT_FONT = this.getCONTENT_FONT();
        result = result * 59 + ($CONTENT_FONT == null ? 43 : $CONTENT_FONT.hashCode());
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    private static final class TestBasicDetailsDisplayBuilderImpl
    extends TestBasicDetailsDisplayBuilder<TestBasicDetailsDisplay, TestBasicDetailsDisplayBuilderImpl> {
        private TestBasicDetailsDisplayBuilderImpl() {
        }

        @Override
        protected TestBasicDetailsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestBasicDetailsDisplay build() {
            return new TestBasicDetailsDisplay(this);
        }
    }

    public static abstract class TestBasicDetailsDisplayBuilder<C extends TestBasicDetailsDisplay, B extends TestBasicDetailsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private Table.TableBuilder tableBuilder;
        private int destinationY;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ", destinationY=" + this.destinationY + ")";
        }
    }
}

