/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.header.PageHeaderAware;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.Section;
import tech.grasshopper.reporter.tests.TestBasicDetailsDisplay;
import tech.grasshopper.reporter.tests.TestGeneratedLogDisplay;
import tech.grasshopper.reporter.tests.TestLogsDisplay;
import tech.grasshopper.reporter.tests.TestMediaDisplay;

public class TestDetails
extends Section
implements PageHeaderAware {
    public static final int LEVEL_X_INDENT = 20;
    protected float yLocation;

    @Override
    public void createSection() {
        if (this.report.getTestList().isEmpty()) {
            return;
        }
        this.pageHeaderDetails();
        this.createPage();
        ArrayList<Test> allTests = new ArrayList<Test>();
        this.report.getTestList().forEach(t -> {
            allTests.add((Test)t);
            this.collectTestNodes((Test)t, (List<Test>)allTests);
        });
        this.displayTestAndLogDetails(allTests);
    }

    protected void displayTestAndLogDetails(List<Test> allTests) {
        for (Test test : allTests) {
            this.displayTestBasicData(test);
            this.displayTestMedias(test);
            this.displayTestGeneratedLogs(test);
            this.displayTestLogs(test);
        }
    }

    protected void displayTestLogs(Test test) {
        if (test.hasLog()) {
            Display testLogsDisplay = ((TestLogsDisplay.TestLogsDisplayBuilder)((Display.DisplayBuilder)((TestLogsDisplay.TestLogsDisplayBuilder)((TestLogsDisplay.TestLogsDisplayBuilder)((TestLogsDisplay.TestLogsDisplayBuilder)((TestLogsDisplay.TestLogsDisplayBuilder)TestLogsDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).annotations(this.annotations)).ylocation(this.yLocation)).build();
            ((TestLogsDisplay)testLogsDisplay).display();
            this.yLocation = testLogsDisplay.getYlocation();
        }
    }

    protected void displayTestGeneratedLogs(Test test) {
        if (!test.getGeneratedLog().isEmpty()) {
            Display testGeneratedLogDisplay = ((TestGeneratedLogDisplay.TestGeneratedLogDisplayBuilder)((Display.DisplayBuilder)((TestGeneratedLogDisplay.TestGeneratedLogDisplayBuilder)((TestGeneratedLogDisplay.TestGeneratedLogDisplayBuilder)((TestGeneratedLogDisplay.TestGeneratedLogDisplayBuilder)TestGeneratedLogDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).ylocation(this.yLocation)).build();
            ((TestGeneratedLogDisplay)testGeneratedLogDisplay).display();
            this.yLocation = testGeneratedLogDisplay.getYlocation();
        }
    }

    protected void displayTestMedias(Test test) {
        if (test.hasScreenCapture()) {
            Display testMediaDisplay = ((TestMediaDisplay.TestMediaDisplayBuilder)((Display.DisplayBuilder)((TestMediaDisplay.TestMediaDisplayBuilder)((TestMediaDisplay.TestMediaDisplayBuilder)((TestMediaDisplay.TestMediaDisplayBuilder)((TestMediaDisplay.TestMediaDisplayBuilder)TestMediaDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).annotations(this.annotations)).ylocation(this.yLocation)).build();
            ((TestMediaDisplay)testMediaDisplay).display();
            this.yLocation = testMediaDisplay.getYlocation();
        }
    }

    protected void displayTestBasicData(Test test) {
        Display testBasicDetailsDisplay = ((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)((Display.DisplayBuilder)((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)((TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder)TestBasicDetailsDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).ylocation(this.yLocation)).build();
        ((TestBasicDetailsDisplay)testBasicDetailsDisplay).display();
        this.createTestDestination((TestBasicDetailsDisplay)testBasicDetailsDisplay);
        this.yLocation = testBasicDetailsDisplay.getYlocation();
    }

    private void collectTestNodes(Test test, List<Test> tests) {
        test.getChildren().forEach(t -> {
            tests.add((Test)t);
            this.collectTestNodes((Test)t, tests);
        });
    }

    private void createTestDestination(TestBasicDetailsDisplay testDisplay) {
        Destination destination = testDisplay.createDestination();
        this.destinations.addTestDestination(destination);
        if (testDisplay.getTest().getLevel() == 0) {
            this.destinations.addTopLevelTestDestination(destination);
        }
    }

    @Override
    public String getSectionTitle() {
        return "TEST DETAILS";
    }

    private static float $default$yLocation() {
        return 790.0f;
    }

    protected TestDetails(TestDetailsBuilder<?, ?> b) {
        super(b);
        this.yLocation = ((TestDetailsBuilder)b).yLocation$set ? ((TestDetailsBuilder)b).yLocation$value : TestDetails.$default$yLocation();
    }

    public static TestDetailsBuilder<?, ?> builder() {
        return new TestDetailsBuilderImpl();
    }

    public float getYLocation() {
        return this.yLocation;
    }

    public void setYLocation(float yLocation) {
        this.yLocation = yLocation;
    }

    @Override
    public String toString() {
        return "TestDetails(yLocation=" + this.getYLocation() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDetails)) {
            return false;
        }
        TestDetails other = (TestDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getYLocation(), other.getYLocation()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYLocation());
        return result;
    }

    private static final class TestDetailsBuilderImpl
    extends TestDetailsBuilder<TestDetails, TestDetailsBuilderImpl> {
        private TestDetailsBuilderImpl() {
        }

        @Override
        protected TestDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public TestDetails build() {
            return new TestDetails(this);
        }
    }

    public static abstract class TestDetailsBuilder<C extends TestDetails, B extends TestDetailsBuilder<C, B>>
    extends Section.SectionBuilder<C, B> {
        private boolean yLocation$set;
        private float yLocation$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B yLocation(float yLocation) {
            this.yLocation$value = yLocation;
            this.yLocation$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestDetails.TestDetailsBuilder(super=" + super.toString() + ", yLocation$value=" + this.yLocation$value + ")";
        }
    }
}

