/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import java.util.List;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.LogDetailsCollector;
import tech.grasshopper.reporter.tests.TestIndent;
import tech.grasshopper.reporter.util.DateUtil;

public class TestLogsDisplay
extends Display
implements TestIndent {
    protected static final float LOGS_HEADER_HEIGHT = 20.0f;
    protected static final int LOGS_HEADER_FONT_SIZE = 11;
    protected static final float PADDING = 5.0f;
    protected static final float LOGS_STATUS_WIDTH = 50.0f;
    private static final float LOGS_TIMESTAMP_WIDTH = 70.0f;
    private static final float LOGS_DETAILS_WIDTH = 380.0f;
    protected static final float BORDER_WIDTH = 1.0f;
    protected static final int LOGS_TABLE_CONTENT_FONT_SIZE = 10;
    protected static final float GAP_HEIGHT = 15.0f;
    protected Test test;
    protected Table.TableBuilder tableBuilder;
    protected AnnotationStore annotations;

    @Override
    public void display() {
        if (this.test.hasLog()) {
            this.xlocation += (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20);
            this.createTableBuilder();
            this.createHeaderRow();
            this.createLogRows();
            this.drawTable();
        }
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(this.columnsWidth()).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP);
    }

    protected float[] columnsWidth() {
        return new float[]{50.0f, 70.0f, 380.0f - (float)(this.test.getLevel() * 20)};
    }

    private void createHeaderRow() {
        Row.RowBuilder rowBuilder = Row.builder().height(Float.valueOf(20.0f)).font(this.reportFont.getItalicFont()).fontSize(Integer.valueOf(11));
        this.tableHeaders(rowBuilder);
        this.tableBuilder.addRow(rowBuilder.build());
    }

    protected void tableHeaders(Row.RowBuilder rowBuilder) {
        rowBuilder.add((AbstractCell)TextCell.builder().text("Status").build()).add((AbstractCell)TextCell.builder().text("Timestamp").build()).add((AbstractCell)TextCell.builder().text("Log Details").build());
    }

    private void createLogRows() {
        this.test.getLogs().forEach(l -> {
            AbstractCell detailsCell = this.createLogDisplayCell((Log)l, this.test);
            Row.RowBuilder rowBuilder = Row.builder().padding(5.0f).font(this.reportFont.getRegularFont()).fontSize(Integer.valueOf(10));
            this.logRow(rowBuilder, detailsCell, (Log)l);
            this.tableBuilder.addRow(rowBuilder.build());
        });
    }

    protected void logRow(Row.RowBuilder rowBuilder, AbstractCell detailsCell, Log l) {
        rowBuilder.add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(l.getStatus().toString())).labelColor(this.config.statusColor(l.getStatus())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.formatTimeAMPM(DateUtil.convertToLocalDateTimeFromDate(l.getTimestamp()))).textColor(this.config.getTestTimeStampColor())).build()).add(detailsCell);
    }

    protected AbstractCell createLogDisplayCell(Log log, Test test) {
        Object logDetailsCollector = ((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)LogDetailsCollector.builder().annotations(this.annotations)).config(this.config)).document(this.document)).reportFont(this.reportFont)).test(test)).width(380.0f - (float)(test.getLevel() * 20))).build();
        List<AbstractCell> allDetailCells = ((LogDetailsCollector)logDetailsCollector).createLogDetailCells(log);
        if (allDetailCells.isEmpty()) {
            return ((TextCell.TextCellBuilder)TextCell.builder().text("").padding(5.0f)).build();
        }
        if (allDetailCells.size() == 1) {
            return allDetailCells.get(0);
        }
        return this.createMultipleDetailsLogCell(allDetailCells);
    }

    protected AbstractCell createMultipleDetailsLogCell(List<AbstractCell> allDetailCells) {
        Table.TableBuilder multipleDetailsBuilder = Table.builder().addColumnsOfWidth(new float[]{380.0f - (float)(this.test.getLevel() * 20)}).borderWidth(0.0f);
        allDetailCells.forEach(c -> {
            if (c != null) {
                multipleDetailsBuilder.addRow(Row.builder().add(c).padding(5.0f).build());
            }
        });
        return ((TableWithinTableCell.TableWithinTableCellBuilder)TableWithinTableCell.builder().table(multipleDetailsBuilder.build()).padding(0.0f)).build();
    }

    private void drawTable() {
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(1).splitRow(true).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 15.0f;
    }

    protected TestLogsDisplay(TestLogsDisplayBuilder<?, ?> b) {
        super(b);
        this.test = ((TestLogsDisplayBuilder)b).test;
        this.tableBuilder = ((TestLogsDisplayBuilder)b).tableBuilder;
        this.annotations = ((TestLogsDisplayBuilder)b).annotations;
    }

    public static TestLogsDisplayBuilder<?, ?> builder() {
        return new TestLogsDisplayBuilderImpl();
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "TestLogsDisplay(test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestLogsDisplay)) {
            return false;
        }
        TestLogsDisplay other = (TestLogsDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestLogsDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class TestLogsDisplayBuilderImpl
    extends TestLogsDisplayBuilder<TestLogsDisplay, TestLogsDisplayBuilderImpl> {
        private TestLogsDisplayBuilderImpl() {
        }

        @Override
        protected TestLogsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestLogsDisplay build() {
            return new TestLogsDisplay(this);
        }
    }

    public static abstract class TestLogsDisplayBuilder<C extends TestLogsDisplay, B extends TestLogsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private Table.TableBuilder tableBuilder;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestLogsDisplay.TestLogsDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ", annotations=" + this.annotations + ")";
        }
    }
}

