/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.cell.ImageCell;
import tech.grasshopper.reporter.medias.Medias;

public class TestMedia
extends Medias {
    private float width;
    private float height;

    @Override
    public ImageCell createImageCell() {
        PDImageXObject image = this.processPDImage();
        return ((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().image(image).width(this.width)).padding(this.padding)).maxHeight(this.height).build();
    }

    protected TestMedia(TestMediaBuilder<?, ?> b) {
        super(b);
        this.width = ((TestMediaBuilder)b).width;
        this.height = ((TestMediaBuilder)b).height;
    }

    public static TestMediaBuilder<?, ?> builder() {
        return new TestMediaBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestMedia)) {
            return false;
        }
        TestMedia other = (TestMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.width, other.width) != 0) {
            return false;
        }
        return Float.compare(this.height, other.height) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.width);
        result = result * 59 + Float.floatToIntBits(this.height);
        return result;
    }

    private static final class TestMediaBuilderImpl
    extends TestMediaBuilder<TestMedia, TestMediaBuilderImpl> {
        private TestMediaBuilderImpl() {
        }

        @Override
        protected TestMediaBuilderImpl self() {
            return this;
        }

        @Override
        public TestMedia build() {
            return new TestMedia(this);
        }
    }

    public static abstract class TestMediaBuilder<C extends TestMedia, B extends TestMediaBuilder<C, B>>
    extends Medias.MediasBuilder<C, B> {
        private float width;
        private float height;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        public B height(float height) {
            this.height = height;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestMedia.TestMediaBuilder(super=" + super.toString() + ", width=" + this.width + ", height=" + this.height + ")";
        }
    }
}

