/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.jsoup.nodes.Element;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import org.vandeseer.easytable.util.PdfUtil;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class CodeBlockMarkup
extends MarkupDisplay {
    private static final Logger logger = Logger.getLogger(CodeBlockMarkup.class.getName());
    private float width;
    private static final int MAX_DASH_COUNT = 100;
    private static final int DEFAULT_DASH_COUNT = 10;

    @Override
    public AbstractCell displayDetails() {
        return ((ParagraphCell.ParagraphCellBuilder)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paragraph(this.codeDetails()).width(this.width)).padding(5.0f)).lineSpacing(1.1f).build();
    }

    private ParagraphCell.Paragraph codeDetails() {
        ParagraphCell.Paragraph.ParagraphBuilder paragraphBuilder = ParagraphCell.Paragraph.builder();
        int count = 1;
        for (Element elem : this.elements) {
            String text = "";
            try {
                text = elem.text();
            }
            catch (Exception e) {
                text = "Error in accessing and processing code block.";
                logger.log(Level.SEVERE, "Unable to process code block.");
            }
            TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
            StyledText codeText = StyledText.builder().fontSize(Float.valueOf(11.0f)).font(this.logFont).color(this.textColor).text(textSanitizer.sanitizeText(text)).build();
            paragraphBuilder.append(codeText);
            if (count < this.elements.size()) {
                paragraphBuilder.appendNewLine(10.0f);
                paragraphBuilder.append(StyledText.builder().fontSize(Float.valueOf(11.0f)).font(this.logFont).color(Color.GRAY).text(this.createDashedLine()).build());
                paragraphBuilder.appendNewLine(10.0f);
            }
            ++count;
        }
        return paragraphBuilder.build();
    }

    private String createDashedLine() {
        List dashedLines = PdfUtil.getOptimalTextBreakLines((String)String.join((CharSequence)"", Collections.nCopies(100, "-")), (PDFont)this.logFont, (int)11, (float)(this.width - 5.0f));
        return dashedLines.isEmpty() ? String.join((CharSequence)"", Collections.nCopies(10, "-")) : (String)dashedLines.get(0);
    }

    protected CodeBlockMarkup(CodeBlockMarkupBuilder<?, ?> b) {
        super(b);
        this.width = ((CodeBlockMarkupBuilder)b).width;
    }

    public static CodeBlockMarkupBuilder<?, ?> builder() {
        return new CodeBlockMarkupBuilderImpl();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public String toString() {
        return "CodeBlockMarkup(width=" + this.getWidth() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeBlockMarkup)) {
            return false;
        }
        CodeBlockMarkup other = (CodeBlockMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getWidth(), other.getWidth()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CodeBlockMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        return result;
    }

    private static final class CodeBlockMarkupBuilderImpl
    extends CodeBlockMarkupBuilder<CodeBlockMarkup, CodeBlockMarkupBuilderImpl> {
        private CodeBlockMarkupBuilderImpl() {
        }

        @Override
        protected CodeBlockMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public CodeBlockMarkup build() {
            return new CodeBlockMarkup(this);
        }
    }

    public static abstract class CodeBlockMarkupBuilder<C extends CodeBlockMarkup, B extends CodeBlockMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private float width;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CodeBlockMarkup.CodeBlockMarkupBuilder(super=" + super.toString() + ", width=" + this.width + ")";
        }
    }
}

