/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class TableMarkup
extends MarkupDisplay {
    protected static final Logger logger = Logger.getLogger(TableMarkup.class.getName());
    protected float width;
    private int maxTableColumnCount;
    protected int displayColumnCount;

    @Override
    public AbstractCell displayDetails() {
        Elements rows = null;
        try {
            rows = this.element.select("tr");
            if (rows.isEmpty()) {
                logger.log(Level.SEVERE, "No data rows available.");
                return this.errorDisplay("Table data is not available.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to retrieve data rows.");
            return this.errorDisplay("Unable to access data.");
        }
        int cols = 0;
        try {
            Element row;
            Iterator iterator = rows.iterator();
            while (iterator.hasNext() && (cols = (row = (Element)iterator.next()).select("td").size()) <= 0) {
            }
            if (cols == 0) {
                logger.log(Level.SEVERE, "No data columns available.");
                return this.errorDisplay("Table data is not available.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to retrieve data columns.");
            return this.errorDisplay("Unable to access data.");
        }
        return TableWithinTableCell.builder().table(this.internalTable(rows, cols)).build();
    }

    protected float[] columnWidthData(int columnCount) {
        float colWidth = this.width / (float)this.displayColumnCount;
        float[] columnWidths = new float[this.displayColumnCount];
        Arrays.fill(columnWidths, colWidth);
        return columnWidths;
    }

    private Table internalTable(Elements rows, int columnCount) {
        this.displayColumnCount = columnCount > this.maxTableColumnCount ? this.maxTableColumnCount : columnCount;
        float[] columnWidths = this.columnWidthData(columnCount);
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(columnWidths).fontSize(Integer.valueOf(11)).font(this.logFont).borderWidth(1.0f).borderColor(Color.LIGHT_GRAY).wordBreak(Boolean.valueOf(true));
        for (Element row : rows) {
            if (row.children().isEmpty()) continue;
            Elements cells = row.select("td");
            if (cells.isEmpty()) {
                logger.log(Level.WARNING, "Row does not contain any cell data.");
                continue;
            }
            tableBuilder.addRow(this.createTableCellData(cells));
        }
        String tableCounts = "";
        String tableSettings = "";
        if (columnCount > this.maxTableColumnCount) {
            tableCounts = this.maxTableColumnCount + " columns";
            tableSettings = "'maxTableColumnCount'";
            logger.log(Level.WARNING, "Only first " + tableCounts + " are shown. Modify the " + tableSettings + " settings.");
            tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(this.displayColumnCount)).text("Only first " + tableCounts + " are shown. Modify the " + tableSettings + " settings.").minHeight(15.0f)).font(this.logFont)).fontSize(Integer.valueOf(10))).textColor(Color.RED)).wordBreak(Boolean.valueOf(true))).lineSpacing(1.0f)).build()).build());
        }
        return tableBuilder.build();
    }

    protected Row createTableCellData(Elements cells) {
        Row.RowBuilder rowBuilder = Row.builder();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
        int j = 1;
        for (Element cell : cells) {
            if (j > this.displayColumnCount) break;
            String text = "";
            try {
                text = cell.text();
            }
            catch (Exception e) {
                text = "Error!";
                logger.log(Level.SEVERE, "Unable to get text for cell, default to error message.");
            }
            rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(text)).textColor(this.textColor)).lineSpacing(1.0f)).build());
            ++j;
        }
        return rowBuilder.build();
    }

    protected TableMarkup(TableMarkupBuilder<?, ?> b) {
        super(b);
        this.width = ((TableMarkupBuilder)b).width;
        this.maxTableColumnCount = ((TableMarkupBuilder)b).maxTableColumnCount;
        this.displayColumnCount = ((TableMarkupBuilder)b).displayColumnCount;
    }

    public static TableMarkupBuilder<?, ?> builder() {
        return new TableMarkupBuilderImpl();
    }

    public float getWidth() {
        return this.width;
    }

    public int getMaxTableColumnCount() {
        return this.maxTableColumnCount;
    }

    public int getDisplayColumnCount() {
        return this.displayColumnCount;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setMaxTableColumnCount(int maxTableColumnCount) {
        this.maxTableColumnCount = maxTableColumnCount;
    }

    @Override
    public String toString() {
        return "TableMarkup(width=" + this.getWidth() + ", maxTableColumnCount=" + this.getMaxTableColumnCount() + ", displayColumnCount=" + this.getDisplayColumnCount() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMarkup)) {
            return false;
        }
        TableMarkup other = (TableMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (this.getMaxTableColumnCount() != other.getMaxTableColumnCount()) {
            return false;
        }
        return this.getDisplayColumnCount() == other.getDisplayColumnCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + this.getMaxTableColumnCount();
        result = result * 59 + this.getDisplayColumnCount();
        return result;
    }

    private static final class TableMarkupBuilderImpl
    extends TableMarkupBuilder<TableMarkup, TableMarkupBuilderImpl> {
        private TableMarkupBuilderImpl() {
        }

        @Override
        protected TableMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public TableMarkup build() {
            return new TableMarkup(this);
        }
    }

    public static abstract class TableMarkupBuilder<C extends TableMarkup, B extends TableMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private float width;
        private int maxTableColumnCount;
        private int displayColumnCount;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        public B maxTableColumnCount(int maxTableColumnCount) {
            this.maxTableColumnCount = maxTableColumnCount;
            return (B)this.self();
        }

        public B displayColumnCount(int displayColumnCount) {
            this.displayColumnCount = displayColumnCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TableMarkup.TableMarkupBuilder(super=" + super.toString() + ", width=" + this.width + ", maxTableColumnCount=" + this.maxTableColumnCount + ", displayColumnCount=" + this.displayColumnCount + ")";
        }
    }
}

