/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import tech.grasshopper.exception.RestAssuredExtentReportPluginException;
import tech.grasshopper.extent.pojo.ResultExtent;
import tech.grasshopper.extent.reports.ReportCreator;
import tech.grasshopper.logging.ReportLogger;
import tech.grasshopper.pojo.Result;
import tech.grasshopper.processor.ResultsProcessor;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.results.JsonResultsCollector;

@Mojo(name="extentreport")
public class RestAssuredExtentReportPlugin
extends AbstractMojo {
    @Parameter(property="extentreport.allureResultsDirectory", defaultValue="target/allure-results")
    private String allureResultsDirectory;
    @Parameter(property="extentreport.reportDirectory", defaultValue="report")
    private String reportDirectory;
    @Parameter(property="extentreport.reportDirectoryTimeStamp", defaultValue="dd MM yyyy HH mm ss")
    private String reportDirectoryTimeStamp;
    @Parameter(property="extentreport.sparkGenerate", defaultValue="true")
    private boolean sparkGenerate;
    @Parameter(property="extentreport.sparkConfigFilePath", defaultValue="src/test/resources/spark-config.xml")
    private String sparkConfigFilePath;
    @Parameter(property="extentreport.pdfGenerate", defaultValue="true")
    private boolean pdfGenerate;
    @Parameter(property="extentreport.pdfConfigFilePath", defaultValue="src/test/resources/pdf-config.xml")
    private String pdfConfigFilePath;
    @Parameter(property="extentreport.systemInfoFilePath", defaultValue="src/test/resources/systeminfo.properties")
    private String systemInfoFilePath;
    @Parameter(property="extentreport.sparkViewOrder")
    private String sparkViewOrder;
    @Parameter(property="extentreport.sparkHideLogEvents", defaultValue="true")
    private boolean sparkHideLogEvents;
    private JsonResultsCollector jsonResultsCollector;
    private ResultsProcessor resultsProcessor;
    private ReportCreator reportCreator;
    private ReportProperties reportProperties;
    private ReportLogger logger;

    @Inject
    public RestAssuredExtentReportPlugin(JsonResultsCollector jsonResultsCollector, ResultsProcessor resultsProcessor, ReportCreator reportCreator, ReportProperties reportProperties, ReportLogger logger) {
        this.jsonResultsCollector = jsonResultsCollector;
        this.resultsProcessor = resultsProcessor;
        this.reportCreator = reportCreator;
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public void execute() {
        try {
            this.logger.initializeLogger(this.getLog());
            this.logger.info("STARTING EXTENT REPORT GENERATION");
            this.setReportProperties();
            if (!this.reportProperties.isSparkGenerate() && !this.reportProperties.isPdfGenerate()) {
                this.logger.info("STOPPING EXTENT REPORT GENERATION - No report type selected.");
                return;
            }
            this.createAttachmentFolder();
            List<Result> results = this.jsonResultsCollector.retrieveResults(this.reportProperties.getAllureResultsDirectory());
            Map<String, List<ResultExtent>> extentReportData = this.resultsProcessor.process(results);
            this.reportCreator.generate(extentReportData);
            this.logger.info("EXTENT REPORT SUCCESSFULLY GENERATED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.logger.error(String.format("STOPPING EXTENT REPORT GENERATION - %s", t.getMessage()));
        }
    }

    private void setReportProperties() {
        this.reportProperties.setAllureResultsDirectory(this.allureResultsDirectory);
        this.reportProperties.setReportDirectory(this.reportDirectory, this.reportDirectoryTimeStamp);
        this.reportProperties.setSystemInfoFilePath(this.systemInfoFilePath);
        this.reportProperties.setSparkGenerate(this.sparkGenerate);
        this.reportProperties.setSparkConfigFilePath(this.sparkConfigFilePath);
        this.reportProperties.setSparkViewOrder(this.sparkViewOrder);
        this.reportProperties.setSparkHidelogEvents(this.sparkHideLogEvents);
        this.reportProperties.setPdfGenerate(this.pdfGenerate);
        this.reportProperties.setPdfConfigFilePath(this.pdfConfigFilePath);
    }

    private void createAttachmentFolder() {
        try {
            Files.createDirectories(Paths.get(this.reportProperties.getReportDirectory(), "data"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RestAssuredExtentReportPluginException("Unable to create report attachments directory.", e);
        }
    }
}

