/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.exception;

import java.lang.reflect.Constructor;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.extent.pojo.ResultExtent;
import tech.grasshopper.logging.ReportLogger;

@Singleton
public class ExceptionParser {
    private ReportLogger logger;

    @Inject
    public ExceptionParser(ReportLogger logger) {
        this.logger = logger;
    }

    public Throwable parseStackTrace(ResultExtent result) {
        String[] details;
        String exceptionClzName = "java.lang.Exception";
        String exceptionMessage = "Error in parsing stacktrace.";
        if (!result.getStackTrace().isEmpty() && !(details = this.retrieveExceptionNameAndMessage(result))[0].isEmpty()) {
            exceptionClzName = details[0];
            exceptionMessage = details[1];
        }
        return this.createThrowableInstance(exceptionClzName, exceptionMessage);
    }

    private String[] retrieveExceptionNameAndMessage(ResultExtent result) {
        String[] details = new String[]{"", ""};
        String[] lines = result.getStackTrace().split("\\R");
        if (lines.length > 0) {
            int colonIndex = lines[0].indexOf(":");
            details[0] = colonIndex > -1 ? lines[0].substring(0, colonIndex) : lines[0];
            details[1] = result.getStatusMessage();
        }
        return details;
    }

    private Throwable createThrowableInstance(String className, String message) {
        Class<?> throwableClass = null;
        try {
            throwableClass = Class.forName(className);
            if (!Throwable.class.isAssignableFrom(throwableClass)) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.warn(className + " class cannot be found or not an instance of Throwable.");
            return new Exception("Generic Exception for " + className + " : " + message);
        }
        return this.createThrowableInstance(className, message, throwableClass);
    }

    private Throwable createThrowableInstance(String className, String message, Class<?> throwableClass) {
        Throwable throwableInstance;
        block5: {
            Constructor<?> throwableConstructor = null;
            throwableInstance = null;
            try {
                if (message.isEmpty()) {
                    throwableConstructor = throwableClass.getConstructor(new Class[0]);
                    throwableInstance = (Throwable)throwableConstructor.newInstance(new Object[0]);
                    break block5;
                }
                try {
                    throwableConstructor = throwableClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException e) {
                    throwableConstructor = throwableClass.getConstructor(Object.class);
                }
                throwableInstance = (Throwable)throwableConstructor.newInstance(message);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                this.logger.warn(className + " constructor cannot be found or cannot be instanciated.");
                throwableInstance = new Exception("Generic Exception for " + className + " : " + message);
            }
        }
        return throwableInstance;
    }
}

