/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.reports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.extent.pojo.ResultExtent;
import tech.grasshopper.extent.reports.ClassLevelTestCreator;
import tech.grasshopper.extent.reports.DataLogCreator;
import tech.grasshopper.extent.reports.MethodLevelTestCreator;
import tech.grasshopper.extent.reports.ReportInitializer;
import tech.grasshopper.extent.reports.StatusLogCreator;

@Singleton
public class ReportCreator {
    private ReportInitializer reportInitializer;
    private ClassLevelTestCreator extentClassLevelCreator;
    private MethodLevelTestCreator extentTestLevelCreator;
    private DataLogCreator dataLogCreator;
    private StatusLogCreator statusLogCreator;

    @Inject
    public ReportCreator(ReportInitializer reportInitializer, ClassLevelTestCreator extentClassLevelCreator, MethodLevelTestCreator extentTestLevelCreator, StatusLogCreator statusLogCreator, DataLogCreator dataLogCreator) {
        this.reportInitializer = reportInitializer;
        this.extentClassLevelCreator = extentClassLevelCreator;
        this.extentTestLevelCreator = extentTestLevelCreator;
        this.statusLogCreator = statusLogCreator;
        this.dataLogCreator = dataLogCreator;
    }

    public void generate(Map<String, List<ResultExtent>> extentReportData) {
        ExtentReports extent = this.reportInitializer.initialize();
        extentReportData.forEach((k, v) -> {
            ExtentTest clzExtentTest = this.extentClassLevelCreator.generate(extent, (String)k, (List<ResultExtent>)v);
            v.forEach(result -> {
                ExtentTest methodExtentTest = this.extentTestLevelCreator.generate(clzExtentTest, (ResultExtent)result);
                this.statusLogCreator.generate(methodExtentTest, (ResultExtent)result);
                this.dataLogCreator.generate(methodExtentTest, (ResultExtent)result);
            });
        });
        extent.flush();
    }
}

