/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.processor;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.extent.pojo.ResultExtent;
import tech.grasshopper.pojo.Result;
import tech.grasshopper.processor.AttachmentProcessor;
import tech.grasshopper.processor.DateProcessor;
import tech.grasshopper.processor.LabelProcessor;
import tech.grasshopper.processor.StatusProcessor;
import tech.grasshopper.properties.ReportProperties;

@Singleton
public class ResultsProcessor {
    private StatusProcessor statusProcessor;
    private DateProcessor dateProcessor;
    private LabelProcessor labelProcessor;
    private ReportProperties reportProperties;
    private AttachmentProcessor attachmentProcessor;

    @Inject
    public ResultsProcessor(StatusProcessor statusProcessor, DateProcessor dateProcessor, LabelProcessor labelProcessor, ReportProperties reportProperties) {
        this.statusProcessor = statusProcessor;
        this.dateProcessor = dateProcessor;
        this.labelProcessor = labelProcessor;
        this.reportProperties = reportProperties;
    }

    public Map<String, List<ResultExtent>> process(List<Result> results) {
        this.deleteExistingAttachmentFiles();
        this.attachmentProcessor = AttachmentProcessor.builder().allureResultsDirectory(this.reportProperties.getAllureResultsDirectory()).reportDirectory(this.reportProperties.getReportDirectory()).build();
        return results.stream().collect(Collectors.mapping(r -> this.transformResult((Result)r), Collectors.groupingBy(e -> e.getClassName())));
    }

    private void deleteExistingAttachmentFiles() {
        Path path = Paths.get(this.reportProperties.getReportDirectory(), "data");
        if (Files.exists(path, new LinkOption[0])) {
            Arrays.stream(new File(path.toString()).listFiles()).forEach(File::delete);
        }
    }

    private ResultExtent transformResult(Result result) {
        return ResultExtent.builder().name(result.getName()).status(this.statusProcessor.process(result.getStatus())).statusMessage(result.getStatusDetails().getMessage()).stackTrace(result.getStatusDetails().getTrace()).startTime(this.dateProcessor.process(result.getStart())).endTime(this.dateProcessor.process(result.getStop())).className(this.labelProcessor.processClassName(result.getLabels())).categories(this.labelProcessor.processCategories(result.getLabels())).authors(this.labelProcessor.processAuthors(result.getLabels())).devices(this.labelProcessor.processDevices(result.getLabels())).dataLogs(this.attachmentProcessor.process(result.getAttachments())).build();
    }
}

