/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.properties;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.logging.ReportLogger;

@Singleton
public class ReportProperties {
    private String allureResultsDirectory;
    private String reportDirectory;
    private String systemInfoFilePath;
    private boolean sparkGenerate;
    private String sparkConfigFilePath;
    private String sparkViewOrder;
    private boolean sparkHidelogEvents;
    private boolean pdfGenerate;
    private String pdfConfigFilePath;
    public static final String EXTENT_REPORT_DATA_DIRECTORY = "data";
    public static final String BODY = "Body";
    public static final String HEADERS = "Headers";
    public static final String COOKIES = "Cookies";
    public static final String ALLURE_RESULTS_DIRECTORY = "target/allure-results";
    public static final String REPORT_DIRECTORY = "report";
    public static final String REPORT_DIRECTORY_TIMESTAMP = "dd MM yyyy HH mm ss";
    public static final String REPORT_SYSTEM_INFO_FILE = "src/test/resources/systeminfo.properties";
    public static final String SPARK_REPORT_GENERATE = "true";
    public static final String SPARK_REPORT_CONFIG_FILE = "src/test/resources/spark-config.xml";
    public static final String SPARK_REPORT_HIDE_LOG_EVENTS = "true";
    public static final String PDF_REPORT_GENERATE = "true";
    public static final String PDF_REPORT_CONFIG_FILE = "src/test/resources/pdf-config.xml";
    private ReportLogger logger;

    @Inject
    public ReportProperties(ReportLogger logger) {
        this.logger = logger;
    }

    public void setReportDirectory(String extentReportDirectory, String extentReportDirectoryTimeStamp) {
        if (extentReportDirectoryTimeStamp == null) {
            this.reportDirectory = extentReportDirectory;
        } else {
            DateTimeFormatter timeStampFormat = null;
            String timeStampStr = "";
            try {
                timeStampFormat = DateTimeFormatter.ofPattern(extentReportDirectoryTimeStamp);
                timeStampStr = timeStampFormat.format(LocalDateTime.now());
            }
            catch (Exception e) {
                this.logger.info("Unable to process supplied date time format pattern. Creating report with default directory timestamp settings.");
                timeStampFormat = DateTimeFormatter.ofPattern(REPORT_DIRECTORY_TIMESTAMP);
                timeStampStr = timeStampFormat.format(LocalDateTime.now());
            }
            this.reportDirectory = extentReportDirectory + " " + timeStampStr;
        }
    }

    public String getAllureResultsDirectory() {
        return this.allureResultsDirectory;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public String getSystemInfoFilePath() {
        return this.systemInfoFilePath;
    }

    public boolean isSparkGenerate() {
        return this.sparkGenerate;
    }

    public String getSparkConfigFilePath() {
        return this.sparkConfigFilePath;
    }

    public String getSparkViewOrder() {
        return this.sparkViewOrder;
    }

    public boolean isSparkHidelogEvents() {
        return this.sparkHidelogEvents;
    }

    public boolean isPdfGenerate() {
        return this.pdfGenerate;
    }

    public String getPdfConfigFilePath() {
        return this.pdfConfigFilePath;
    }

    public ReportLogger getLogger() {
        return this.logger;
    }

    public void setAllureResultsDirectory(String allureResultsDirectory) {
        this.allureResultsDirectory = allureResultsDirectory;
    }

    public void setSystemInfoFilePath(String systemInfoFilePath) {
        this.systemInfoFilePath = systemInfoFilePath;
    }

    public void setSparkGenerate(boolean sparkGenerate) {
        this.sparkGenerate = sparkGenerate;
    }

    public void setSparkConfigFilePath(String sparkConfigFilePath) {
        this.sparkConfigFilePath = sparkConfigFilePath;
    }

    public void setSparkViewOrder(String sparkViewOrder) {
        this.sparkViewOrder = sparkViewOrder;
    }

    public void setSparkHidelogEvents(boolean sparkHidelogEvents) {
        this.sparkHidelogEvents = sparkHidelogEvents;
    }

    public void setPdfGenerate(boolean pdfGenerate) {
        this.pdfGenerate = pdfGenerate;
    }

    public void setPdfConfigFilePath(String pdfConfigFilePath) {
        this.pdfConfigFilePath = pdfConfigFilePath;
    }

    public void setLogger(ReportLogger logger) {
        this.logger = logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportProperties)) {
            return false;
        }
        ReportProperties other = (ReportProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSparkGenerate() != other.isSparkGenerate()) {
            return false;
        }
        if (this.isSparkHidelogEvents() != other.isSparkHidelogEvents()) {
            return false;
        }
        if (this.isPdfGenerate() != other.isPdfGenerate()) {
            return false;
        }
        String this$allureResultsDirectory = this.getAllureResultsDirectory();
        String other$allureResultsDirectory = other.getAllureResultsDirectory();
        if (this$allureResultsDirectory == null ? other$allureResultsDirectory != null : !this$allureResultsDirectory.equals(other$allureResultsDirectory)) {
            return false;
        }
        String this$reportDirectory = this.getReportDirectory();
        String other$reportDirectory = other.getReportDirectory();
        if (this$reportDirectory == null ? other$reportDirectory != null : !this$reportDirectory.equals(other$reportDirectory)) {
            return false;
        }
        String this$systemInfoFilePath = this.getSystemInfoFilePath();
        String other$systemInfoFilePath = other.getSystemInfoFilePath();
        if (this$systemInfoFilePath == null ? other$systemInfoFilePath != null : !this$systemInfoFilePath.equals(other$systemInfoFilePath)) {
            return false;
        }
        String this$sparkConfigFilePath = this.getSparkConfigFilePath();
        String other$sparkConfigFilePath = other.getSparkConfigFilePath();
        if (this$sparkConfigFilePath == null ? other$sparkConfigFilePath != null : !this$sparkConfigFilePath.equals(other$sparkConfigFilePath)) {
            return false;
        }
        String this$sparkViewOrder = this.getSparkViewOrder();
        String other$sparkViewOrder = other.getSparkViewOrder();
        if (this$sparkViewOrder == null ? other$sparkViewOrder != null : !this$sparkViewOrder.equals(other$sparkViewOrder)) {
            return false;
        }
        String this$pdfConfigFilePath = this.getPdfConfigFilePath();
        String other$pdfConfigFilePath = other.getPdfConfigFilePath();
        if (this$pdfConfigFilePath == null ? other$pdfConfigFilePath != null : !this$pdfConfigFilePath.equals(other$pdfConfigFilePath)) {
            return false;
        }
        ReportLogger this$logger = this.getLogger();
        ReportLogger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSparkGenerate() ? 79 : 97);
        result = result * 59 + (this.isSparkHidelogEvents() ? 79 : 97);
        result = result * 59 + (this.isPdfGenerate() ? 79 : 97);
        String $allureResultsDirectory = this.getAllureResultsDirectory();
        result = result * 59 + ($allureResultsDirectory == null ? 43 : $allureResultsDirectory.hashCode());
        String $reportDirectory = this.getReportDirectory();
        result = result * 59 + ($reportDirectory == null ? 43 : $reportDirectory.hashCode());
        String $systemInfoFilePath = this.getSystemInfoFilePath();
        result = result * 59 + ($systemInfoFilePath == null ? 43 : $systemInfoFilePath.hashCode());
        String $sparkConfigFilePath = this.getSparkConfigFilePath();
        result = result * 59 + ($sparkConfigFilePath == null ? 43 : $sparkConfigFilePath.hashCode());
        String $sparkViewOrder = this.getSparkViewOrder();
        result = result * 59 + ($sparkViewOrder == null ? 43 : $sparkViewOrder.hashCode());
        String $pdfConfigFilePath = this.getPdfConfigFilePath();
        result = result * 59 + ($pdfConfigFilePath == null ? 43 : $pdfConfigFilePath.hashCode());
        ReportLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "ReportProperties(allureResultsDirectory=" + this.getAllureResultsDirectory() + ", reportDirectory=" + this.getReportDirectory() + ", systemInfoFilePath=" + this.getSystemInfoFilePath() + ", sparkGenerate=" + this.isSparkGenerate() + ", sparkConfigFilePath=" + this.getSparkConfigFilePath() + ", sparkViewOrder=" + this.getSparkViewOrder() + ", sparkHidelogEvents=" + this.isSparkHidelogEvents() + ", pdfGenerate=" + this.isPdfGenerate() + ", pdfConfigFilePath=" + this.getPdfConfigFilePath() + ", logger=" + this.getLogger() + ")";
    }
}

