/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.util;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.TextSequenceUtil;
import rst.pdfbox.layout.util.Pair;
import rst.pdfbox.layout.util.WordBreaker;

public class WordBreakers {

    public static class DefaultWordBreaker
    extends AbstractWordBreaker {
        private final Pattern breakPattern = Pattern.compile("[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff]([\\-\\.\\,/])");

        @Override
        protected Pair<String> breakWordSoft(String word, FontDescriptor fontDescriptor, float maxWidth) throws IOException {
            Matcher matcher = this.breakPattern.matcher(word);
            int breakIndex = -1;
            boolean maxWidthExceeded = false;
            while (!maxWidthExceeded && matcher.find()) {
                int currentIndex = matcher.end();
                if (currentIndex >= word.length() - 1) continue;
                if (TextSequenceUtil.getStringWidth(word.substring(0, currentIndex), fontDescriptor) < maxWidth) {
                    breakIndex = currentIndex;
                    continue;
                }
                maxWidthExceeded = true;
            }
            if (breakIndex < 0) {
                return null;
            }
            return new Pair<String>(word.substring(0, breakIndex), word.substring(breakIndex));
        }
    }

    public static abstract class AbstractWordBreaker
    implements WordBreaker {
        @Override
        public Pair<String> breakWord(String word, FontDescriptor fontDescriptor, float maxWidth, boolean breakHardIfNecessary) throws IOException {
            Pair<String> brokenWord = this.breakWordSoft(word, fontDescriptor, maxWidth);
            if (brokenWord == null && breakHardIfNecessary) {
                brokenWord = this.breakWordHard(word, fontDescriptor, maxWidth);
            }
            return brokenWord;
        }

        protected abstract Pair<String> breakWordSoft(String var1, FontDescriptor var2, float var3) throws IOException;

        protected Pair<String> breakWordHard(String word, FontDescriptor fontDescriptor, float maxWidth) throws IOException {
            int cutIndex = (int)(maxWidth / TextSequenceUtil.getEmWidth(fontDescriptor));
            float currentWidth = TextSequenceUtil.getStringWidth(word.substring(0, cutIndex), fontDescriptor);
            if (currentWidth > maxWidth) {
                while (currentWidth > maxWidth) {
                    currentWidth = TextSequenceUtil.getStringWidth(word.substring(0, --cutIndex), fontDescriptor);
                }
                ++cutIndex;
            } else if (currentWidth < maxWidth) {
                while (currentWidth < maxWidth) {
                    currentWidth = TextSequenceUtil.getStringWidth(word.substring(0, ++cutIndex), fontDescriptor);
                }
                --cutIndex;
            }
            return new Pair<String>(word.substring(0, cutIndex), word.substring(cutIndex));
        }
    }

    public static class NonBreakingWordBreaker
    implements WordBreaker {
        @Override
        public Pair<String> breakWord(String word, FontDescriptor fontDescriptor, float maxWidth, boolean breakHardIfNecessary) throws IOException {
            return null;
        }
    }
}

