/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.generator.plugin;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import tech.ibit.mybatis.generator.Generator;
import tech.ibit.mybatis.generator.ProjectInfo;

@Mojo(name="generate")
public class GeneratorMojo
extends AbstractMojo {
    @Parameter(name="driverName", required=true)
    private String driverName;
    @Parameter(name="jdbcUrl", required=true)
    private String jdbcUrl;
    @Parameter(name="username", required=true)
    private String username;
    @Parameter(name="password", required=true)
    private String password;
    @Parameter(name="defaultProjectDir", defaultValue="${project.basedir}")
    private File defaultProjectDir;
    @Parameter(name="defaultBasePackage")
    private String defaultBasePackage;
    @Parameter(name="entityProjectDir")
    private File entityProjectDir;
    @Parameter(name="entityBasePackage")
    private String entityBasePackage;
    @Parameter(name="mapperProjectDir")
    private File mapperProjectDir;
    @Parameter(name="mapperBasePackage")
    private String mapperBasePackage;
    @Parameter(name="author")
    private String author;
    @Parameter(name="withAll", defaultValue="false")
    private boolean withAll;
    @Parameter(name="withEntity", defaultValue="false")
    private boolean withEntity;
    @Parameter(name="withMapper", defaultValue="false")
    private boolean withMapper;
    @Parameter(name="override", defaultValue="false")
    private boolean override;
    @Parameter(name="tables", required=true)
    private String tables;

    public void execute() {
        Generator generator = new Generator(this.driverName, this.jdbcUrl, this.username, this.password, this.tables);
        ProjectInfo defaultProject = new ProjectInfo(this.defaultProjectDir.getAbsolutePath(), this.defaultBasePackage);
        generator.setDefaultProject(defaultProject);
        if (null != this.entityProjectDir || StringUtils.isNotBlank((String)this.entityBasePackage)) {
            generator.setEntityProject(new ProjectInfo(this.getPath(this.entityProjectDir, this.defaultProjectDir), this.getString(this.entityBasePackage, this.defaultBasePackage)));
        }
        if (null != this.mapperProjectDir || StringUtils.isNotBlank((String)this.mapperBasePackage)) {
            generator.setMapperProject(new ProjectInfo(this.getPath(this.mapperProjectDir, this.defaultProjectDir), this.getString(this.mapperBasePackage, this.defaultBasePackage)));
        }
        generator.setAuthor(StringUtils.trimToEmpty((String)this.author));
        generator.setOverride(this.override);
        if (this.withAll) {
            generator.setWithAll();
        } else {
            generator.setWithEntity(this.withEntity);
            generator.setWithMapper(this.withMapper);
        }
        generator.generateFiles();
    }

    private String getString(String value, String defaultValue) {
        return StringUtils.isNotBlank((String)value) ? value.trim() : defaultValue.trim();
    }

    private String getPath(File file, File defaultFile) {
        return null != file ? file.getAbsolutePath() : defaultFile.getAbsolutePath();
    }
}

