/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.mybatis.generator.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import tech.ibit.mybatis.generator.Generator;
import tech.ibit.mybatis.generator.ProjectInfo;
import tech.ibit.mybatis.generator.plugin.utils.PropertyUtils;

@Mojo(name="generate-with-config")
public class GeneratorWithConfigFileMojo
extends AbstractMojo {
    @Parameter(name="configFile", required=true)
    private File configFile;

    private Properties getProperties() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fin = new FileInputStream(this.configFile);){
            properties.load(fin);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public void execute() {
        try {
            Properties properties = this.getProperties();
            Generator generator = new Generator(PropertyUtils.getString(properties, "driverName"), PropertyUtils.getString(properties, "jdbcUrl"), PropertyUtils.getString(properties, "username"), PropertyUtils.getString(properties, "password"), PropertyUtils.getString(properties, "tables"));
            String defaultProjectDir = PropertyUtils.getString(properties, "defaultProjectDir");
            String defaultBasePackage = PropertyUtils.getString(properties, "defaultBasePackage");
            ProjectInfo defaultProject = new ProjectInfo(defaultProjectDir, defaultBasePackage);
            generator.setDefaultProject(defaultProject);
            String entityProjectDir = PropertyUtils.getString(properties, "entityProjectDir");
            String entityBasePackage = PropertyUtils.getString(properties, "entityBasePackage");
            if (StringUtils.isNotBlank((String)entityProjectDir) || StringUtils.isNotBlank((String)entityBasePackage)) {
                generator.setEntityProject(new ProjectInfo(this.getString(entityProjectDir, defaultProjectDir), this.getString(entityBasePackage, defaultBasePackage)));
            }
            String mapperProjectDir = PropertyUtils.getString(properties, "mapperProjectDir");
            String mapperBasePackage = PropertyUtils.getString(properties, "mapperBasePackage");
            if (StringUtils.isNotBlank((String)mapperProjectDir) || StringUtils.isNotBlank((String)mapperBasePackage)) {
                generator.setMapperProject(new ProjectInfo(this.getString(mapperProjectDir, defaultProjectDir), this.getString(mapperBasePackage, defaultBasePackage)));
            }
            generator.setAuthor(PropertyUtils.getString(properties, "author"));
            generator.setOverride(PropertyUtils.getBoolean(properties, "override"));
            boolean withAll = PropertyUtils.getBoolean(properties, "withAll");
            if (withAll) {
                generator.setWithAll();
            } else {
                generator.setWithEntity(PropertyUtils.getBoolean(properties, "withEntity"));
                generator.setWithMapper(PropertyUtils.getBoolean(properties, "withMapper"));
            }
            generator.generateFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getString(String value, String defaultValue) {
        return StringUtils.isNotBlank((String)value) ? value.trim() : defaultValue.trim();
    }
}

