/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.column.support.IColumnCriteriaItemSupport;
import tech.ibit.sqlbuilder.column.support.IColumnOrderBySupport;

public class AggregateColumn
implements IColumn,
IColumnOrderBySupport,
IColumnCriteriaItemSupport {
    private static final String COLUMN_SEPARATOR = ", ";
    private static final String ALL_COLUMNS = "*";
    private String functionName;
    private IColumn[] columns;
    private String nameAs;
    private boolean distinct;

    public AggregateColumn(String functionName, IColumn[] columns, String nameAs) {
        this(functionName, columns, nameAs, false);
    }

    public AggregateColumn(String functionName, IColumn[] columns, String nameAs, boolean distinct) {
        this.functionName = functionName;
        this.columns = columns;
        this.nameAs = nameAs;
        this.distinct = distinct;
    }

    @Override
    public String getName() {
        return this.getColumnName(this.getColumnNames());
    }

    @Override
    public String getNameWithTableAlias() {
        return this.getColumnName(this.getColumnNamesWithTableAlias());
    }

    private String getColumnName(String columnNames) {
        return this.functionName + "(" + (this.distinct ? "DISTINCT " : "") + columnNames + ")";
    }

    private String getColumnNames() {
        if (ArrayUtils.isEmpty((Object[])this.columns)) {
            return ALL_COLUMNS;
        }
        return Arrays.stream(this.columns).map(IColumn::getName).collect(Collectors.joining(COLUMN_SEPARATOR));
    }

    private String getColumnNamesWithTableAlias() {
        if (ArrayUtils.isEmpty((Object[])this.columns)) {
            return ALL_COLUMNS;
        }
        return Arrays.stream(this.columns).map(IColumn::getNameWithTableAlias).collect(Collectors.joining(COLUMN_SEPARATOR));
    }

    @Override
    public IColumn getColumn() {
        return this;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public IColumn[] getColumns() {
        return this.columns;
    }

    public void setColumns(IColumn[] columns) {
        this.columns = columns;
    }

    @Override
    public String getNameAs() {
        return this.nameAs;
    }

    public void setNameAs(String nameAs) {
        this.nameAs = nameAs;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String toString() {
        return new StringJoiner(COLUMN_SEPARATOR, AggregateColumn.class.getSimpleName() + "[", "]").add("functionName='" + this.functionName + "'").add("columns=" + Arrays.toString(this.columns)).add("nameAs='" + this.nameAs + "'").add("distinct=" + this.distinct).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateColumn that = (AggregateColumn)o;
        return this.isDistinct() == that.isDistinct() && this.getFunctionName().equals(that.getFunctionName()) && Arrays.equals(this.getColumns(), that.getColumns()) && Objects.equals(this.getNameAs(), that.getNameAs());
    }

    public int hashCode() {
        int result = Objects.hash(this.getFunctionName(), this.getNameAs(), this.isDistinct());
        result = 31 * result + Arrays.hashCode(this.getColumns());
        return result;
    }
}

