/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Objects;
import java.util.StringJoiner;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.column.support.IColumnAggregateSupport;
import tech.ibit.sqlbuilder.column.support.IColumnCriteriaItemSupport;
import tech.ibit.sqlbuilder.column.support.IColumnFullTextSupport;
import tech.ibit.sqlbuilder.column.support.IColumnOrderBySupport;
import tech.ibit.sqlbuilder.column.support.IColumnSetItemSupport;
import tech.ibit.sqlbuilder.column.support.IColumnUniqueKeySupport;

public class Column
implements IColumn,
IColumnCriteriaItemSupport,
IColumnAggregateSupport,
IColumnFullTextSupport,
IColumnSetItemSupport,
IColumnOrderBySupport,
IColumnUniqueKeySupport {
    private Table table;
    private String name;

    public Column(Table table, String name) {
        this.table = table;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return Objects.equals(this.getTable(), column.getTable()) && Objects.equals(this.getName(), column.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getTable(), this.getName());
    }

    public String toString() {
        return new StringJoiner(", ", Column.class.getSimpleName() + "[", "]").add("table=" + this.table).add("name='" + this.name + "'").toString();
    }

    @Override
    public String getNameWithTableAlias() {
        return this.table.getAlias() + "." + this.name;
    }

    @Override
    public String getNameAs() {
        return null;
    }

    @Override
    public IColumn getColumn() {
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

