/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.PrepareStatementSupplier;
import tech.ibit.sqlbuilder.enums.CriteriaLogicalEnum;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class Criteria
implements PrepareStatementSupplier {
    private CriteriaLogicalEnum logical;
    private CriteriaItem item;
    private List<Criteria> subCriterion;

    private Criteria(CriteriaLogicalEnum logical, List<Criteria> subCriterion) {
        this.logical = logical;
        this.subCriterion = subCriterion;
    }

    private Criteria(CriteriaLogicalEnum logical, CriteriaItem item) {
        this.logical = logical;
        this.item = item;
    }

    public static Criteria or(List<Criteria> subCriterion) {
        return new Criteria(CriteriaLogicalEnum.OR, subCriterion);
    }

    public static Criteria or(CriteriaItem item) {
        return new Criteria(CriteriaLogicalEnum.OR, item);
    }

    public static Criteria and(List<Criteria> subCriterion) {
        return new Criteria(CriteriaLogicalEnum.AND, subCriterion);
    }

    public static Criteria and(CriteriaItem item) {
        return new Criteria(CriteriaLogicalEnum.AND, item);
    }

    public static List<Criteria> ors(List<?> items) {
        if (null == items || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> criterion = new ArrayList<Criteria>();
        for (Object item : items) {
            if (item instanceof CriteriaItem) {
                criterion.add(Criteria.or((CriteriaItem)item));
                continue;
            }
            criterion.add(Criteria.or((List)item));
        }
        return criterion;
    }

    public static List<Criteria> ands(List<?> items) {
        if (null == items || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> criterion = new ArrayList<Criteria>();
        for (Object item : items) {
            if (item instanceof CriteriaItem) {
                criterion.add(Criteria.and((CriteriaItem)item));
                continue;
            }
            criterion.add(Criteria.and((List)item));
        }
        return criterion;
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        if (null == this.item && CollectionUtils.isEmpty(this.subCriterion)) {
            return null;
        }
        StringBuilder whereSql = new StringBuilder();
        ArrayList<ColumnValue> whereParams = new ArrayList<ColumnValue>();
        this.appendCriteria(this, whereSql, whereParams, useAlias);
        return new PrepareStatement(whereSql.toString(), whereParams);
    }

    private void appendCriteria(Criteria criteria, StringBuilder criteriaSql, List<ColumnValue> whereParams, boolean useAlias) {
        if (null != criteria.getItem()) {
            CriteriaItem item = criteria.getItem();
            PrepareStatement statement = item.getPrepareStatement(useAlias);
            criteriaSql.append(statement.getPrepareSql());
            whereParams.addAll(statement.getValues());
        } else if (CollectionUtils.isNotEmpty(criteria.getSubCriterion())) {
            if (1 == criteria.getSubCriterion().size()) {
                this.appendCriteria(criteria.getSubCriterion().get(0), criteriaSql, whereParams, useAlias);
            } else {
                criteriaSql.append("(");
                List<Criteria> subCriterion = criteria.getSubCriterion();
                for (int i = 0; i < subCriterion.size(); ++i) {
                    Criteria subCriteria = subCriterion.get(i);
                    if (0 != i) {
                        criteriaSql.append(" ").append(subCriteria.getLogical().name()).append(" ");
                    }
                    if (null == subCriteria.getItem() && !CollectionUtils.isNotEmpty(subCriteria.getSubCriterion())) continue;
                    this.appendCriteria(subCriteria, criteriaSql, whereParams, useAlias);
                }
                criteriaSql.append(")");
            }
        }
    }

    public CriteriaLogicalEnum getLogical() {
        return this.logical;
    }

    public void setLogical(CriteriaLogicalEnum logical) {
        this.logical = logical;
    }

    public CriteriaItem getItem() {
        return this.item;
    }

    public void setItem(CriteriaItem item) {
        this.item = item;
    }

    public List<Criteria> getSubCriterion() {
        return this.subCriterion;
    }

    public void setSubCriterion(List<Criteria> subCriterion) {
        this.subCriterion = subCriterion;
    }
}

