/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.List;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.CriteriaMaker;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.OrderBy;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class CustomOrderBy
extends OrderBy {
    private List<?> subOrders;

    public CustomOrderBy(IColumn column, List<?> subOrders) {
        this(column, subOrders, false);
    }

    public CustomOrderBy(IColumn column, List<?> subOrders, boolean desc) {
        super(column, desc);
        this.subOrders = subOrders;
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        if (CollectionUtils.isEmpty(this.subOrders)) {
            return null;
        }
        String columnName = this.getColumn().getCompareColumnName(useAlias);
        String prepareSql = "FIELD(" + columnName + ", " + CriteriaMaker.getIn(this.subOrders.size()) + ")" + (this.isDesc() ? " DESC" : "");
        List<ColumnValue> subOrderKeyValuePairs = this.subOrders.stream().map(o -> new ColumnValue(this.getColumn(), o)).collect(Collectors.toList());
        return new PrepareStatement(prepareSql, subOrderKeyValuePairs);
    }

    public List<?> getSubOrders() {
        return this.subOrders;
    }

    public void setSubOrders(List<?> subOrders) {
        this.subOrders = subOrders;
    }
}

