/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.CriteriaMaker;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.enums.CriteriaItemValueTypeEnum;
import tech.ibit.sqlbuilder.enums.OperatorEnum;

public class DefaultCriteriaItem
extends CriteriaItem {
    private final IColumn column;
    private final OperatorEnum operator;
    private final IColumn secondColumn;
    private final Object value;
    private final Object secondValue;
    private final CriteriaItemValueTypeEnum valueType;

    public DefaultCriteriaItem(IColumn column, OperatorEnum operator, IColumn secondColumn, Object value, Object secondValue, CriteriaItemValueTypeEnum valueType) {
        this.column = column;
        this.operator = operator;
        this.secondColumn = secondColumn;
        this.value = value;
        this.secondValue = secondValue;
        this.valueType = valueType;
    }

    public static CriteriaItem getNoValueInstance(IColumn column, OperatorEnum operator) {
        return new DefaultCriteriaItem(column, operator, null, null, null, CriteriaItemValueTypeEnum.NO_VALUE);
    }

    public static CriteriaItem getColumnCompareInstance(IColumn column, OperatorEnum operator, IColumn secondColumn) {
        return new DefaultCriteriaItem(column, operator, secondColumn, null, null, CriteriaItemValueTypeEnum.COLUMN_COMPARE);
    }

    public static CriteriaItem getSingleValueInstance(IColumn column, OperatorEnum operator, Object value) {
        return new DefaultCriteriaItem(column, operator, null, value, null, CriteriaItemValueTypeEnum.SINGLE_VALUE);
    }

    public static CriteriaItem getMultiValueInstance(IColumn column, OperatorEnum operator, Collection<?> values) {
        return new DefaultCriteriaItem(column, operator, null, values, null, CriteriaItemValueTypeEnum.LIST_VALUE);
    }

    public static CriteriaItem getBetweenInstance(IColumn column, OperatorEnum operator, Object value, Object secondValue) {
        return new DefaultCriteriaItem(column, operator, null, value, secondValue, CriteriaItemValueTypeEnum.BETWEEN_VALUE);
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        switch (this.valueType) {
            case COLUMN_COMPARE: {
                return this.getColumnsComparePrepareStatement(useAlias);
            }
            case NO_VALUE: {
                return this.getNoValuePrepareStatement(useAlias);
            }
            case SINGLE_VALUE: {
                return this.getSingleValuePrepareStatement(useAlias);
            }
            case BETWEEN_VALUE: {
                return this.getBetweenPrepareStatement(useAlias);
            }
            case LIST_VALUE: {
                return this.getListPrepareStatement(useAlias);
            }
        }
        return null;
    }

    private PrepareStatement getColumnsComparePrepareStatement(boolean useAlias) {
        String sql = this.column.getCompareColumnName(useAlias) + " " + this.operator.getValue() + " " + this.secondColumn.getCompareColumnName(useAlias);
        return new PrepareStatement(sql, Collections.emptyList());
    }

    private PrepareStatement getNoValuePrepareStatement(boolean useAlias) {
        String sql = this.column.getCompareColumnName(useAlias) + " " + this.operator.getValue();
        return new PrepareStatement(sql, Collections.emptyList());
    }

    private PrepareStatement getSingleValuePrepareStatement(boolean useAlias) {
        String sql = this.column.getCompareColumnName(useAlias) + " " + this.operator.getValue() + " ?";
        return new PrepareStatement(sql, Collections.singletonList(new ColumnValue(this.column, this.value)));
    }

    private PrepareStatement getBetweenPrepareStatement(boolean useAlias) {
        String sql = this.column.getCompareColumnName(useAlias) + " " + this.operator.getValue() + " ? " + this.operator.getSecondValue() + " ?";
        return new PrepareStatement(sql, Arrays.asList(new ColumnValue(this.column, this.value), new ColumnValue(this.column, this.secondValue)));
    }

    private PrepareStatement getListPrepareStatement(boolean useAlias) {
        Collection values = (Collection)this.value;
        String sql = this.column.getCompareColumnName(useAlias) + " " + this.operator.getValue() + "(" + CriteriaMaker.getIn(values.size()) + ")";
        List<ColumnValue> keyValuePairs = values.stream().map(v -> new ColumnValue(this.column, v)).collect(Collectors.toList());
        return new PrepareStatement(sql, keyValuePairs);
    }

    public IColumn getColumn() {
        return this.column;
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public IColumn getSecondColumn() {
        return this.secondColumn;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getSecondValue() {
        return this.secondValue;
    }

    public CriteriaItemValueTypeEnum getValueType() {
        return this.valueType;
    }
}

