/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Collections;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.PrepareStatement;

public class FlagCriteriaItem
extends CriteriaItem {
    private final IColumn column;
    private final long value;
    private ContainsType containsType;

    private FlagCriteriaItem(IColumn column, ContainsType containsType, long value) {
        this.column = column;
        this.value = value;
        this.containsType = containsType;
    }

    public static FlagCriteriaItem getInstance(IColumn column, ContainsType containsType, long value) {
        return new FlagCriteriaItem(column, containsType, value);
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        StringBuilder whereSql = new StringBuilder();
        String columnName = this.column.getCompareColumnName(useAlias);
        switch (this.containsType) {
            case CONTAINS_ALL: {
                whereSql.append(columnName).append(" & ? = ").append(columnName);
                break;
            }
            case CONTAINS_NONE: {
                whereSql.append(columnName).append(" & ? = 0");
                break;
            }
            case CONTAINS_ANY: {
                whereSql.append(columnName).append(" & ? <> 0");
                break;
            }
        }
        return new PrepareStatement(whereSql.toString(), Collections.singletonList(new ColumnValue(this.column, this.value)));
    }

    public ContainsType getContainsType() {
        return this.containsType;
    }

    public void setContainsType(ContainsType containsType) {
        this.containsType = containsType;
    }

    public IColumn getColumn() {
        return this.column;
    }

    public long getValue() {
        return this.value;
    }

    public static enum ContainsType {
        CONTAINS_ALL,
        CONTAINS_NONE,
        CONTAINS_ANY;

    }
}

