/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.FullTextCriteriaItem;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.column.support.IColumnCriteriaItemSupport;
import tech.ibit.sqlbuilder.column.support.IColumnOrderBySupport;
import tech.ibit.sqlbuilder.enums.FullTextModeEnum;

public class FullTextColumn
implements IColumn,
IColumnOrderBySupport,
IColumnCriteriaItemSupport {
    private static final String COLUMN_SEPARATOR = ", ";
    private final IColumn[] columns;
    private final String value;
    private final FullTextModeEnum mode;
    private final String nameAs;

    public FullTextColumn(IColumn[] columns, String value, String nameAs) {
        this(columns, value, null, nameAs);
    }

    public FullTextColumn(IColumn[] columns, String value, FullTextModeEnum mode, String nameAs) {
        this.columns = columns;
        this.value = value;
        this.mode = mode;
        this.nameAs = nameAs;
    }

    @Override
    public String getName() {
        return this.getColumnName(this.getColumnNames());
    }

    @Override
    public String getNameWithTableAlias() {
        return this.getColumnName(this.getColumnNamesWithTableAlias());
    }

    @Override
    public String getNameAs() {
        return this.nameAs;
    }

    @Override
    public IColumn getColumn() {
        return this;
    }

    public ColumnValue value() {
        return new ColumnValue(this, this.value);
    }

    public FullTextCriteriaItem match() {
        return FullTextCriteriaItem.getInstance(this);
    }

    private String getColumnName(String columnNames) {
        return "MATCH(" + columnNames + ") AGAINST(?" + this.getModeClause() + ")";
    }

    private String getModeClause() {
        if (null == this.mode) {
            return "";
        }
        switch (this.mode) {
            case BOOLEAN: {
                return " IN BOOLEAN MODE";
            }
            case NATURAL_LANGUAGE: {
                return " IN NATURAL LANGUAGE MODE";
            }
        }
        return "";
    }

    private String getColumnNames() {
        return Arrays.stream(this.columns).map(IColumn::getName).collect(Collectors.joining(COLUMN_SEPARATOR));
    }

    private String getColumnNamesWithTableAlias() {
        return Arrays.stream(this.columns).map(IColumn::getNameWithTableAlias).collect(Collectors.joining(COLUMN_SEPARATOR));
    }

    public String getValue() {
        return this.value;
    }

    public FullTextModeEnum getMode() {
        return this.mode;
    }

    public IColumn[] getColumns() {
        return this.columns;
    }

    public String toString() {
        return new StringJoiner(COLUMN_SEPARATOR, FullTextColumn.class.getSimpleName() + "[", "]").add("columns=" + Arrays.toString(this.columns)).add("value='" + this.value + "'").add("mode=" + (Object)((Object)this.mode)).add("nameAs='" + this.nameAs + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullTextColumn column = (FullTextColumn)o;
        return Arrays.equals(this.getColumns(), column.getColumns()) && this.getValue().equals(column.getValue()) && this.getMode() == column.getMode() && Objects.equals(this.getNameAs(), column.getNameAs());
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.getValue(), this.getMode(), this.getNameAs()});
        result = 31 * result + Arrays.hashCode(this.getColumns());
        return result;
    }
}

