/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.ArrayList;
import java.util.List;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.CriteriaMaker;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.PrepareStatementSupplier;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.enums.JoinOnTypeEnum;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class JoinOn
implements PrepareStatementSupplier {
    public static final int PAIRS_SIZE = 2;
    private final JoinOnTypeEnum joinOnType;
    private final Table table;
    private final List<Column> columnPairs;
    private final List<CriteriaItem> criteriaItems;

    private JoinOn(JoinOnTypeEnum joinOnType, Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        this.joinOnType = joinOnType;
        this.table = table;
        this.columnPairs = columnPairs;
        this.criteriaItems = criteriaItems;
    }

    public static JoinOn none(Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        return JoinOn.getInstance(null, table, columnPairs, criteriaItems);
    }

    public static JoinOn none(Table table, List<Column> columnPairs) {
        return JoinOn.getInstance(null, table, columnPairs, null);
    }

    public static JoinOn full(Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        return JoinOn.getInstance(JoinOnTypeEnum.FULL, table, columnPairs, criteriaItems);
    }

    public static JoinOn full(Table table, List<Column> columnPairs) {
        return JoinOn.getInstance(JoinOnTypeEnum.FULL, table, columnPairs, null);
    }

    public static JoinOn left(Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        return JoinOn.getInstance(JoinOnTypeEnum.LEFT, table, columnPairs, criteriaItems);
    }

    public static JoinOn left(Table table, List<Column> columnPairs) {
        return JoinOn.getInstance(JoinOnTypeEnum.LEFT, table, columnPairs, null);
    }

    public static JoinOn right(Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        return JoinOn.getInstance(JoinOnTypeEnum.RIGHT, table, columnPairs, criteriaItems);
    }

    public static JoinOn right(Table table, List<Column> columnPairs) {
        return JoinOn.getInstance(JoinOnTypeEnum.RIGHT, table, columnPairs, null);
    }

    public static JoinOn inner(Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        return JoinOn.getInstance(JoinOnTypeEnum.INNER, table, columnPairs, criteriaItems);
    }

    public static JoinOn inner(Table table, List<Column> columnPairs) {
        return JoinOn.getInstance(JoinOnTypeEnum.INNER, table, columnPairs, null);
    }

    private static JoinOn getInstance(JoinOnTypeEnum joinOnType, Table table, List<Column> columnPairs, List<CriteriaItem> criteriaItems) {
        return new JoinOn(joinOnType, table, columnPairs, criteriaItems);
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        StringBuilder prepareSql = new StringBuilder();
        prepareSql.append(null == this.joinOnType ? "" : this.joinOnType.name() + " ").append("JOIN ").append(this.table.getTableName(useAlias)).append(" ON ");
        boolean hasOn = false;
        if (CollectionUtils.isNotEmpty(this.columnPairs)) {
            for (int i = 0; i < this.columnPairs.size(); i += 2) {
                if (hasOn) {
                    prepareSql.append(" AND ");
                }
                prepareSql.append(CriteriaMaker.eq(this.columnPairs.get(i).getCompareColumnName(useAlias), this.columnPairs.get(i + 1).getCompareColumnName(useAlias)));
                hasOn = true;
            }
        }
        if (CollectionUtils.isNotEmpty(this.criteriaItems)) {
            for (CriteriaItem item : this.criteriaItems) {
                if (hasOn) {
                    prepareSql.append(" AND ");
                }
                PrepareStatement itemPrepareStatement = item.getPrepareStatement(useAlias);
                prepareSql.append(itemPrepareStatement.getPrepareSql());
                values.addAll(itemPrepareStatement.getValues());
                hasOn = true;
            }
        }
        return new PrepareStatement(prepareSql.toString(), values);
    }

    public JoinOnTypeEnum getJoinOnType() {
        return this.joinOnType;
    }

    public Table getTable() {
        return this.table;
    }

    public List<Column> getColumnPairs() {
        return this.columnPairs;
    }

    public List<CriteriaItem> getCriteriaItems() {
        return this.criteriaItems;
    }
}

