/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Collections;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.IOrderBy;
import tech.ibit.sqlbuilder.PrepareStatement;

public class OrderBy
implements IOrderBy {
    private IColumn column;
    private boolean desc;

    public OrderBy(IColumn column) {
        this(column, false);
    }

    public OrderBy(IColumn column, boolean desc) {
        this.column = column;
        this.desc = desc;
    }

    @Override
    public PrepareStatement getPrepareStatement(boolean useAlias) {
        String columnName = this.getColumn().getCompareColumnName(useAlias);
        String prepareSql = columnName + (this.desc ? " DESC" : "");
        return new PrepareStatement(prepareSql, Collections.emptyList());
    }

    @Override
    public IColumn getColumn() {
        return this.column;
    }

    public void setColumn(IColumn column) {
        this.column = column;
    }

    @Override
    public boolean isDesc() {
        return this.desc;
    }

    public void setDesc(boolean desc) {
        this.desc = desc;
    }
}

