/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class PrepareStatement {
    private String prepareSql;
    private List<ColumnValue> values;

    public PrepareStatement(String prepareSql, List<ColumnValue> values) {
        this.prepareSql = prepareSql;
        this.values = values;
    }

    public static PrepareStatement empty() {
        return new PrepareStatement("", Collections.emptyList());
    }

    public List<Object> getParams() {
        if (CollectionUtils.isEmpty(this.values)) {
            return Collections.emptyList();
        }
        return this.values.stream().map(ColumnValue::getValue).collect(Collectors.toList());
    }

    public String getPrepareSql() {
        return this.prepareSql;
    }

    public void setPrepareSql(String prepareSql) {
        this.prepareSql = prepareSql;
    }

    public List<ColumnValue> getValues() {
        return this.values;
    }

    public void setValues(List<ColumnValue> values) {
        this.values = values;
    }

    public String toString() {
        return new StringJoiner(", ", PrepareStatement.class.getSimpleName() + "[", "]").add("prepareSql='" + this.prepareSql + "'").add("values=" + this.values).toString();
    }
}

