/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;

public class Table {
    private String name;
    private String alias;

    public Table(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getNameWithAlias() {
        return this.name + " " + this.alias;
    }

    public String getTableName(boolean useAlias) {
        return useAlias ? this.getNameWithAlias() : this.getName();
    }

    public String getSelectTableName(boolean userAlias) {
        return !userAlias || StringUtils.isBlank((String)this.alias) ? this.getName() : this.getAlias();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.getName(), table.getName()) && Objects.equals(this.getAlias(), table.getAlias());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAlias());
    }

    public String toString() {
        return new StringJoiner(", ", Table.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("alias='" + this.alias + "'").toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

