/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.column.support;

import java.util.ArrayList;
import java.util.Collection;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.DefaultCriteriaItem;
import tech.ibit.sqlbuilder.FlagCriteriaItem;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.column.support.IColumnSupport;
import tech.ibit.sqlbuilder.enums.OperatorEnum;

public interface IColumnCriteriaItemSupport
extends IColumnSupport {
    default public CriteriaItem isNull() {
        return DefaultCriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_NULL);
    }

    default public CriteriaItem isNotNull() {
        return DefaultCriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_NOT_NULL);
    }

    default public CriteriaItem isEmpty() {
        return DefaultCriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_EMPTY);
    }

    default public CriteriaItem isNotEmpty() {
        return DefaultCriteriaItem.getNoValueInstance(this.getColumn(), OperatorEnum.IS_NOT_EMPTY);
    }

    default public CriteriaItem eq(Object value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.EQ, value);
    }

    default public CriteriaItem eq(IColumn secondColumn) {
        return DefaultCriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.EQ, secondColumn);
    }

    default public CriteriaItem neq(Object value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.NEQ, value);
    }

    default public CriteriaItem neq(IColumn secondColumn) {
        return DefaultCriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.NEQ, secondColumn);
    }

    default public CriteriaItem gt(Object value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.GT, value);
    }

    default public CriteriaItem gt(IColumn secondColumn) {
        return DefaultCriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.GT, secondColumn);
    }

    default public CriteriaItem egt(Object value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.EGT, value);
    }

    default public CriteriaItem egt(IColumn secondColumn) {
        return DefaultCriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.EGT, secondColumn);
    }

    default public CriteriaItem lt(Object value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.LT, value);
    }

    default public CriteriaItem lt(IColumn secondColumn) {
        return DefaultCriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.LT, secondColumn);
    }

    default public CriteriaItem elt(Object value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.ELT, value);
    }

    default public CriteriaItem elt(IColumn secondColumn) {
        return DefaultCriteriaItem.getColumnCompareInstance(this.getColumn(), OperatorEnum.ELT, secondColumn);
    }

    default public CriteriaItem in(Collection<?> values) {
        if (null != values && 1 == values.size()) {
            return this.eq(new ArrayList(values).get(0));
        }
        return DefaultCriteriaItem.getMultiValueInstance(this.getColumn(), OperatorEnum.IN, values);
    }

    default public CriteriaItem notIn(Collection<?> values) {
        if (null != values && 1 == values.size()) {
            return this.neq(new ArrayList(values).get(0));
        }
        return DefaultCriteriaItem.getMultiValueInstance(this.getColumn(), OperatorEnum.NOT_IN, values);
    }

    default public CriteriaItem between(Object value1, Object value2) {
        return DefaultCriteriaItem.getBetweenInstance(this.getColumn(), OperatorEnum.BETWEEN, value1, value2);
    }

    default public CriteriaItem notBetween(Object value1, Object value2) {
        return DefaultCriteriaItem.getBetweenInstance(this.getColumn(), OperatorEnum.NOT_BETWEEN, value1, value2);
    }

    default public CriteriaItem like(String value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.LIKE, value);
    }

    default public CriteriaItem notLike(String value) {
        return DefaultCriteriaItem.getSingleValueInstance(this.getColumn(), OperatorEnum.NOT_LIKE, value);
    }

    default public CriteriaItem allFlgs(long flags) {
        return FlagCriteriaItem.getInstance(this.getColumn(), FlagCriteriaItem.ContainsType.CONTAINS_ALL, flags);
    }

    default public CriteriaItem noFlgs(long flags) {
        return FlagCriteriaItem.getInstance(this.getColumn(), FlagCriteriaItem.ContainsType.CONTAINS_NONE, flags);
    }

    default public CriteriaItem anyFlgs(long flags) {
        return FlagCriteriaItem.getInstance(this.getColumn(), FlagCriteriaItem.ContainsType.CONTAINS_ANY, flags);
    }
}

